/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.util;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import tech.uom.seshat.util.WeakEntry;

public final class WeakHashSet<E>
extends AbstractSet<E> {
    private Entry[] table;
    private int count;
    private final Class<E> elementType;
    private transient long lastTimeNormalCapacity;
    private static final int REMOVE = -1;
    private static final int GET = 0;
    private static final int ADD = 1;
    private static final int INTERN = 2;

    public WeakHashSet(Class<E> clazz) {
        this.elementType = clazz;
        this.lastTimeNormalCapacity = System.nanoTime();
        Entry[] entryArray = (Entry[])Array.newInstance(Entry.class, 7);
        this.table = entryArray;
    }

    private synchronized void removeEntry(Entry entry) {
        assert (this.isValid());
        int n = this.table.length;
        if (entry.removeFrom(this.table, entry.hash % n)) {
            long l;
            --this.count;
            assert (this.isValid());
            if (this.count < WeakEntry.lowerCapacityThreshold(n) && (l = System.nanoTime()) - this.lastTimeNormalCapacity > 4000000000L) {
                this.table = (Entry[])WeakEntry.rehash(this.table, this.count);
                this.lastTimeNormalCapacity = l;
                assert (this.isValid());
            }
        }
    }

    private boolean isValid() {
        if (!Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.count > WeakEntry.upperCapacityThreshold(this.table.length)) {
            throw new AssertionError(this.count);
        }
        return WeakEntry.count(this.table) == this.count;
    }

    @Override
    public synchronized int size() {
        assert (this.isValid());
        return this.count;
    }

    @Override
    public synchronized boolean add(E e) {
        Objects.requireNonNull(e);
        return this.intern(e, 1) == null;
    }

    @Override
    public synchronized boolean remove(Object object) {
        return this.intern(object, -1) != null;
    }

    public synchronized E get(Object object) {
        return this.intern(object, 0);
    }

    @Override
    public synchronized boolean contains(Object object) {
        return this.intern(object, 0) != null;
    }

    public synchronized <T extends E> T unique(T t) {
        return (T)this.intern(t, 2);
    }

    private E intern(Object object, int n) {
        assert (this.isValid());
        if (object != null) {
            Entry[] entryArray = this.table;
            int n2 = object.hashCode() & Integer.MAX_VALUE;
            int n3 = n2 % entryArray.length;
            Entry entry = entryArray[n3];
            while (entry != null) {
                Object t = entry.get();
                if (object.equals(t)) {
                    if (n == -1) {
                        entry.dispose();
                    }
                    return (E)t;
                }
                entry = (Entry)entry.next;
            }
            if (n >= 1) {
                if (++this.count >= WeakEntry.lowerCapacityThreshold(entryArray.length)) {
                    if (this.count > WeakEntry.upperCapacityThreshold(entryArray.length)) {
                        this.table = entryArray = (Entry[])WeakEntry.rehash(entryArray, this.count);
                        n3 = n2 % entryArray.length;
                    }
                    this.lastTimeNormalCapacity = System.nanoTime();
                }
                entry = this.elementType.cast(object);
                entryArray[n3] = new Entry(entry, entryArray[n3], n2);
                assert (this.isValid());
                if (n == 2) {
                    return (E)entry;
                }
            }
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized E[] toArray() {
        assert (this.isValid());
        Object[] objectArray = (Object[])Array.newInstance(this.elementType, this.count);
        int n = 0;
        for (Entry entry : this.table) {
            while (entry != null) {
                objectArray[n] = entry.get();
                if (objectArray[n] != null) {
                    ++n;
                }
                entry = (Entry)entry.next;
            }
        }
        if (objectArray.length != n) {
            objectArray = Arrays.copyOf(objectArray, n);
        }
        return objectArray;
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.toArray()).iterator();
    }

    private final class Entry
    extends WeakEntry<E> {
        Entry(E e, Entry entry, int n) {
            super(e, entry, n);
        }

        @Override
        public void dispose() {
            super.clear();
            WeakHashSet.this.removeEntry(this);
        }
    }
}

