/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.util;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import tech.uom.seshat.util.DerivedSet;

public final class DerivedMap<SK, SV, K, V>
extends AbstractMap<K, V>
implements Function<Map.Entry<SK, SV>, Map.Entry<K, V>> {
    private final Map<SK, SV> storage;
    private final Function<SK, K> keyConverter;
    private final Function<SV, V> valueConverter;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;

    public DerivedMap(Map<SK, SV> map, Function<SK, K> function, Function<SV, V> function2) {
        this.storage = map;
        this.keyConverter = function;
        this.valueConverter = function2;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty() || this.keySet().isEmpty();
    }

    @Override
    public final Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new DerivedSet<SK, K>(this.storage.keySet(), this.keyConverter);
        }
        return this.keySet;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new DerivedSet<Map.Entry<SK, SV>, Map.Entry<K, V>>(this.storage.entrySet(), this);
        }
        return this.entrySet;
    }

    @Override
    public final Map.Entry<K, V> apply(Map.Entry<SK, SV> entry) {
        K k = this.keyConverter.apply(entry.getKey());
        if (k != null) {
            V v = this.valueConverter.apply(entry.getValue());
            return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
        }
        return null;
    }
}

