/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.util;

import java.util.Iterator;
import java.util.function.Function;

final class DerivedIterator<S, E>
implements Iterator<E> {
    private final Iterator<S> iterator;
    private final Function<S, E> converter;
    private transient E next;

    DerivedIterator(Iterator<S> iterator, Function<S, E> function) {
        this.iterator = iterator;
        this.converter = function;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null) {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.next = this.converter.apply(this.iterator.next());
        }
        return true;
    }

    @Override
    public E next() {
        E e = this.next;
        this.next = null;
        while (e == null) {
            e = this.converter.apply(this.iterator.next());
        }
        return e;
    }
}

