/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import tech.uom.seshat.resources.KeyConstants;

public abstract class IndexedResourceBundle
extends ResourceBundle {
    private static final String EXTENSION = ".utf";
    static final int FIRST = 1;
    private volatile String[] values;
    private transient MessageFormat format;
    private transient short lastKey;

    IndexedResourceBundle() {
    }

    protected static <T extends IndexedResourceBundle> T getBundle(Class<T> clazz, Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return (T)((IndexedResourceBundle)clazz.cast(IndexedResourceBundle.getBundle(clazz.getName(), locale, clazz.getModule())));
    }

    abstract KeyConstants getKeyConstants();

    @Override
    public final Enumeration<String> getKeys() {
        return new KeyEnum(this.getKeyConstants().getKeyNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] ensureLoaded(String string) throws MissingResourceException {
        String[] stringArray = this.values;
        if (stringArray == null) {
            IndexedResourceBundle indexedResourceBundle = this;
            synchronized (indexedResourceBundle) {
                stringArray = this.values;
                if (stringArray == null) {
                    Class<?> clazz = this.getClass();
                    InputStream inputStream = clazz.getResourceAsStream(clazz.getSimpleName() + EXTENSION);
                    if (inputStream == null) {
                        stringArray = ((IndexedResourceBundle)this.parent).ensureLoaded(string);
                    } else {
                        try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
                            stringArray = new String[dataInputStream.readInt()];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray[i] = dataInputStream.readUTF();
                                if (!stringArray[i].isEmpty()) continue;
                                stringArray[i] = null;
                            }
                        }
                        catch (IOException iOException) {
                            throw (MissingResourceException)new MissingResourceException(iOException.getLocalizedMessage(), clazz.getCanonicalName(), string).initCause(iOException);
                        }
                    }
                    this.values = stringArray;
                }
            }
        }
        return stringArray;
    }

    @Override
    protected final Object handleGetObject(String string) {
        int n;
        String[] stringArray = this.ensureLoaded(string);
        try {
            n = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                n = this.getKeyConstants().getKeyValue(string);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                reflectiveOperationException.addSuppressed(numberFormatException);
                System.getLogger("tech.uom.seshat").log(System.Logger.Level.WARNING, reflectiveOperationException);
                return null;
            }
        }
        return --n >= 0 && n < stringArray.length ? stringArray[n] : null;
    }

    final Object[] toArray(Object object) {
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        return objectArray;
    }

    public final String getString(short s) throws MissingResourceException {
        return this.getString(String.valueOf(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(short s, Object object) throws MissingResourceException {
        String string = this.getString(s);
        Object[] objectArray = this.toArray(object);
        IndexedResourceBundle indexedResourceBundle = this;
        synchronized (indexedResourceBundle) {
            if (this.format == null) {
                this.format = new MessageFormat(string, this.getLocale());
                this.lastKey = s;
            } else if (s != this.lastKey) {
                this.format.applyPattern(string);
                this.lastKey = s;
            }
            try {
                return this.format.format(objectArray);
            }
            catch (RuntimeException runtimeException) {
                return "[Unformattable message: " + runtimeException + "]";
            }
        }
    }

    public final String getString(short s, Object object, Object object2) throws MissingResourceException {
        return this.getString(s, new Object[]{object, object2});
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "[" + this.getLocale() + "]";
    }

    private static final class KeyEnum
    implements Enumeration<String> {
        private final String[] keys;
        private int next;

        KeyEnum(String[] stringArray) {
            this.keys = stringArray;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.next < this.keys.length) {
                if (this.keys[this.next] != null) {
                    return true;
                }
                ++this.next;
            }
            return false;
        }

        @Override
        public String nextElement() {
            while (this.next < this.keys.length) {
                String string;
                if ((string = this.keys[this.next++]) == null) continue;
                return string;
            }
            throw new NoSuchElementException();
        }
    }
}

