/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat;

import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import tech.uom.seshat.AbstractConverter;
import tech.uom.seshat.AbstractUnit;
import tech.uom.seshat.ConventionalUnit;
import tech.uom.seshat.LinearConverter;
import tech.uom.seshat.PowerOf10;
import tech.uom.seshat.Prefixes;
import tech.uom.seshat.Scalar;
import tech.uom.seshat.ScalarFactory;
import tech.uom.seshat.SystemUnit;
import tech.uom.seshat.UnitDimension;
import tech.uom.seshat.UnitFormat;
import tech.uom.seshat.UnitRegistry;
import tech.uom.seshat.resources.Errors;

public final class Units {
    public static final Unit<Length> NANOMETRE;
    public static final Unit<Length> MILLIMETRE;
    public static final Unit<Length> CENTIMETRE;
    public static final Unit<Length> METRE;
    public static final Unit<Length> KILOMETRE;
    public static final Unit<Length> NAUTICAL_MILE;
    public static final Unit<Length> STATUTE_MILE;
    public static final Unit<Length> US_SURVEY_FOOT;
    public static final Unit<Length> CLARKE_FOOT;
    public static final Unit<Length> FOOT;
    public static final Unit<Length> INCH;
    public static final Unit<Length> POINT;
    public static final Unit<Area> SQUARE_METRE;
    public static final Unit<Area> HECTARE;
    public static final Unit<Volume> CUBIC_METRE;
    public static final Unit<Volume> LITRE;
    public static final Unit<SolidAngle> STERADIAN;
    public static final Unit<Angle> MICRORADIAN;
    public static final Unit<Angle> RADIAN;
    public static final Unit<Angle> DEGREE;
    public static final Unit<Angle> ARC_MINUTE;
    public static final Unit<Angle> ARC_SECOND;
    public static final Unit<Angle> GRAD;
    public static final Unit<Time> MILLISECOND;
    public static final Unit<Time> SECOND;
    public static final Unit<Time> MINUTE;
    public static final Unit<Time> HOUR;
    public static final Unit<Time> DAY;
    public static final Unit<Time> WEEK;
    public static final Unit<Time> TROPICAL_YEAR;
    public static final Unit<Frequency> HERTZ;
    public static final Unit<Speed> METRES_PER_SECOND;
    public static final Unit<Speed> KILOMETRES_PER_HOUR;
    public static final Unit<Pressure> PASCAL;
    public static final Unit<Pressure> HECTOPASCAL;
    public static final Unit<Pressure> DECIBAR;
    public static final Unit<Pressure> BAR;
    public static final Unit<Pressure> ATMOSPHERE;
    public static final Unit<Force> NEWTON;
    public static final Unit<Energy> JOULE;
    public static final Unit<Power> WATT;
    public static final Unit<ElectricPotential> VOLT;
    public static final Unit<ElectricCurrent> AMPERE;
    public static final Unit<ElectricCharge> COULOMB;
    public static final Unit<ElectricCapacitance> FARAD;
    public static final Unit<ElectricResistance> OHM;
    public static final Unit<ElectricConductance> SIEMENS;
    public static final Unit<MagneticFlux> WEBER;
    public static final Unit<MagneticFluxDensity> TESLA;
    public static final Unit<ElectricInductance> HENRY;
    public static final Unit<Temperature> KELVIN;
    public static final Unit<Temperature> CELSIUS;
    public static final Unit<Temperature> FAHRENHEIT;
    public static final Unit<LuminousIntensity> CANDELA;
    public static final Unit<LuminousFlux> LUMEN;
    public static final Unit<Illuminance> LUX;
    public static final Unit<Mass> GRAM;
    public static final Unit<Mass> KILOGRAM;
    public static final Unit<AmountOfSubstance> MOLE;
    public static final Unit<Dimensionless> UNITY;
    public static final Unit<Dimensionless> PERCENT;
    public static final Unit<Dimensionless> PPM;
    public static final Unit<Dimensionless> DECIBEL;
    public static final Unit<Dimensionless> PIXEL;
    static final boolean initialized;

    private static <Q extends Quantity<Q>> SystemUnit<Q> add(Class<Q> clazz, ScalarFactory<Q> scalarFactory, UnitDimension unitDimension, String string, byte by) {
        return UnitRegistry.init(new SystemUnit<Q>(clazz, unitDimension, string, by, scalarFactory));
    }

    private static <Q extends Quantity<Q>> ConventionalUnit<Q> add(AbstractUnit<Q> abstractUnit, UnitConverter unitConverter, String string, byte by) {
        ConventionalUnit<Q> conventionalUnit = UnitRegistry.init(new ConventionalUnit<Q>(abstractUnit, unitConverter, string, by));
        ConventionalUnit<Q>[] conventionalUnitArray = abstractUnit.related();
        if (!(conventionalUnitArray == null || conventionalUnit.scope == 2 && unitConverter.isLinear())) {
            int n = 0;
            while (conventionalUnitArray[n] != null) {
                ++n;
            }
            conventionalUnitArray[n] = conventionalUnit;
        }
        return conventionalUnit;
    }

    static SystemUnit<?> get(Dimension dimension) {
        return (SystemUnit)UnitRegistry.get(dimension);
    }

    static <Q extends Quantity<Q>> SystemUnit<Q> get(Class<Q> clazz) {
        return (SystemUnit)UnitRegistry.get(clazz);
    }

    static Unit<?> get(String string) {
        return (Unit)UnitRegistry.get(string);
    }

    private Units() {
    }

    public static boolean isAngular(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(RADIAN);
    }

    public static boolean isLinear(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(METRE);
    }

    public static boolean isPressure(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(PASCAL);
    }

    public static boolean isTemporal(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(SECOND);
    }

    public static boolean isScale(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(UNITY);
    }

    public static Unit<Angle> ensureAngular(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isAngular(unit)) {
            throw new IllegalArgumentException(Errors.format((short)7, unit));
        }
        return unit;
    }

    public static Unit<Length> ensureLinear(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isLinear(unit)) {
            throw new IllegalArgumentException(Errors.format((short)9, unit));
        }
        return unit;
    }

    public static Unit<Time> ensureTemporal(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isTemporal(unit)) {
            throw new IllegalArgumentException(Errors.format((short)13, unit));
        }
        return unit;
    }

    public static Unit<Dimensionless> ensureScale(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isScale(unit)) {
            throw new IllegalArgumentException(Errors.format((short)11, unit));
        }
        return unit;
    }

    public static <Q extends Quantity<Q>> Unit<Q> multiply(Unit<Q> unit, double d, double d2) {
        return unit.transform((UnitConverter)LinearConverter.scale(d, d2));
    }

    public static <Q extends Quantity<Q>> double toStandardUnit(Unit<Q> unit) {
        return AbstractConverter.scale(unit == null ? null : unit.getConverterTo(unit.getSystemUnit()));
    }

    public static UnitConverter converter(Number number, Number number2) {
        return LinearConverter.create(number, number2);
    }

    public static Number[] coefficients(UnitConverter unitConverter) {
        if (unitConverter != null) {
            if (unitConverter instanceof AbstractConverter) {
                return ((AbstractConverter)unitConverter).coefficients();
            }
            if (unitConverter.isIdentity()) {
                return new Number[0];
            }
            if (unitConverter.isLinear()) {
                double d = unitConverter.convert(0.0);
                double d2 = unitConverter.convert(1.0) - d;
                Number[] numberArray = new Number[d2 != 1.0 ? 2 : (d != 0.0 ? 1 : 0)];
                switch (numberArray.length) {
                    case 2: {
                        numberArray[1] = d2;
                    }
                    case 1: {
                        numberArray[0] = d;
                    }
                }
                return numberArray;
            }
        }
        return null;
    }

    public static double derivative(UnitConverter unitConverter, double d) {
        return AbstractConverter.derivative(unitConverter, d);
    }

    public static Unit<?> valueOf(String string) throws ParserException {
        return string != null ? UnitFormat.INSTANCE.parse(string) : null;
    }

    static {
        UnitDimension unitDimension = new UnitDimension('L');
        UnitDimension unitDimension2 = new UnitDimension('M');
        UnitDimension unitDimension3 = new UnitDimension('T');
        UnitDimension unitDimension4 = new UnitDimension('I');
        UnitDimension unitDimension5 = new UnitDimension('\u0398');
        UnitDimension unitDimension6 = new UnitDimension('N');
        UnitDimension unitDimension7 = new UnitDimension('J');
        UnitDimension unitDimension8 = unitDimension3.pow(-1);
        UnitDimension unitDimension9 = unitDimension.pow(2);
        UnitDimension unitDimension10 = unitDimension.divide(unitDimension3);
        UnitDimension unitDimension11 = unitDimension2.multiply(unitDimension10).divide(unitDimension3);
        UnitDimension unitDimension12 = unitDimension11.multiply(unitDimension);
        UnitDimension unitDimension13 = unitDimension12.divide(unitDimension3);
        UnitDimension unitDimension14 = unitDimension4.multiply(unitDimension3);
        UnitDimension unitDimension15 = unitDimension13.divide(unitDimension4);
        UnitDimension unitDimension16 = unitDimension15.multiply(unitDimension3);
        UnitDimension unitDimension17 = unitDimension11.divide(unitDimension9);
        UnitDimension unitDimension18 = UnitDimension.NONE;
        SystemUnit<Length> systemUnit = Units.add(Length.class, Scalar.Length::new, unitDimension, "m", (byte)3);
        SystemUnit<Area> systemUnit2 = Units.add(Area.class, Scalar.Area::new, unitDimension9, "m\u00b2", (byte)3);
        SystemUnit<Volume> systemUnit3 = Units.add(Volume.class, Scalar.Volume::new, unitDimension.pow(3), "m\u00b3", (byte)3);
        SystemUnit<Time> systemUnit4 = Units.add(Time.class, Scalar.Time::new, unitDimension3, "s", (byte)3);
        SystemUnit<Temperature> systemUnit5 = Units.add(Temperature.class, Scalar.Temperature.FACTORY, unitDimension5, "\u212a", (byte)3);
        SystemUnit<Speed> systemUnit6 = Units.add(Speed.class, Scalar.Speed::new, unitDimension10, "m\u2215s", (byte)3);
        SystemUnit<Pressure> systemUnit7 = Units.add(Pressure.class, Scalar.Pressure::new, unitDimension17, "Pa", (byte)3);
        SystemUnit<Angle> systemUnit8 = Units.add(Angle.class, Scalar.Angle::new, unitDimension18, "rad", (byte)3);
        SystemUnit<Dimensionless> systemUnit9 = Units.add(Dimensionless.class, Scalar.Dimensionless::new, unitDimension18, "", (byte)2);
        SystemUnit<Mass> systemUnit10 = Units.add(Mass.class, Scalar.Mass::new, unitDimension2, "kg", (byte)2);
        LinearConverter linearConverter = Prefixes.converter('n');
        LinearConverter linearConverter2 = Prefixes.converter('\u00b5');
        LinearConverter linearConverter3 = Prefixes.converter('m');
        LinearConverter linearConverter4 = Prefixes.converter('c');
        LinearConverter linearConverter5 = Prefixes.converter('h');
        LinearConverter linearConverter6 = Prefixes.converter('k');
        LinearConverter linearConverter7 = LinearConverter.scale(10000.0, 1.0);
        systemUnit8.related(4);
        RADIAN = systemUnit8;
        GRAD = Units.add(systemUnit8, LinearConverter.scale(0.15707963267948966, 10.0), "grad", (byte)16);
        DEGREE = Units.add(systemUnit8, LinearConverter.scale(0.15707963267948966, 9.0), "\u00b0", (byte)4);
        ARC_MINUTE = Units.add(systemUnit8, LinearConverter.scale(0.15707963267948966, 540.0), "\u2032", (byte)4);
        ARC_SECOND = Units.add(systemUnit8, LinearConverter.scale(0.15707963267948966, 32400.0), "\u2033", (byte)4);
        MICRORADIAN = Units.add(systemUnit8, linearConverter2, "\u00b5rad", (byte)2);
        systemUnit.related(7);
        METRE = systemUnit;
        NANOMETRE = Units.add(systemUnit, linearConverter, "nm", (byte)2);
        MILLIMETRE = Units.add(systemUnit, linearConverter3, "mm", (byte)2);
        CENTIMETRE = Units.add(systemUnit, linearConverter4, "cm", (byte)2);
        KILOMETRE = Units.add(systemUnit, linearConverter6, "km", (byte)2);
        NAUTICAL_MILE = Units.add(systemUnit, LinearConverter.scale(1852.0, 1.0), "M", (byte)16);
        STATUTE_MILE = Units.add(systemUnit, LinearConverter.scale(1609344.0, 100.0), "mi", (byte)8);
        US_SURVEY_FOOT = Units.add(systemUnit, LinearConverter.scale(1200.0, 3937.0), "ftUS", (byte)16);
        CLARKE_FOOT = Units.add(systemUnit, LinearConverter.scale(3.047972654E9, 1.0E10), "ftCla", (byte)16);
        FOOT = Units.add(systemUnit, LinearConverter.scale(3048.0, 10000.0), "ft", (byte)8);
        INCH = Units.add(systemUnit, LinearConverter.scale(254.0, 10000.0), "in", (byte)8);
        POINT = Units.add(systemUnit, LinearConverter.scale(996264.0, 7.2E7), "pt", (byte)16);
        systemUnit4.related(5);
        SECOND = systemUnit4;
        MILLISECOND = Units.add(systemUnit4, linearConverter3, "ms", (byte)2);
        MINUTE = Units.add(systemUnit4, LinearConverter.scale(60.0, 1.0), "min", (byte)4);
        HOUR = Units.add(systemUnit4, LinearConverter.scale(3600.0, 1.0), "h", (byte)4);
        DAY = Units.add(systemUnit4, LinearConverter.scale(86400.0, 1.0), "d", (byte)4);
        WEEK = Units.add(systemUnit4, LinearConverter.scale(604800.0, 1.0), "wk", (byte)16);
        TROPICAL_YEAR = Units.add(systemUnit4, LinearConverter.scale(3.1556925445E10, 1000.0), "a", (byte)16);
        systemUnit6.related(1);
        METRES_PER_SECOND = systemUnit6;
        KILOMETRES_PER_HOUR = Units.add(systemUnit6, LinearConverter.scale(10.0, 36.0), "km\u2215h", (byte)4);
        systemUnit7.related(3);
        PASCAL = systemUnit7;
        HECTOPASCAL = Units.add(systemUnit7, linearConverter5, "hPa", (byte)2);
        DECIBAR = Units.add(systemUnit7, linearConverter7, "dbar", (byte)16);
        BAR = Units.add(systemUnit7, LinearConverter.scale(100000.0, 1.0), "bar", (byte)16);
        ATMOSPHERE = Units.add(systemUnit7, LinearConverter.scale(101325.0, 1.0), "atm", (byte)16);
        systemUnit5.related(2);
        KELVIN = systemUnit5;
        CELSIUS = Units.add(systemUnit5, LinearConverter.offset(27315.0, 100.0), "\u00b0C", (byte)2);
        FAHRENHEIT = Units.add(systemUnit5, new LinearConverter(100.0, 45967.0, 180.0), "\u00b0F", (byte)16);
        SQUARE_METRE = systemUnit2;
        CUBIC_METRE = systemUnit3;
        KILOGRAM = systemUnit10;
        HECTARE = Units.add(systemUnit2, linearConverter7, "ha", (byte)4);
        LITRE = Units.add(systemUnit3, linearConverter3, "L", (byte)5);
        GRAM = Units.add(systemUnit10, linearConverter3, "g", (byte)5);
        HERTZ = Units.add(Frequency.class, Scalar.Frequency::new, unitDimension8, "Hz", (byte)3);
        NEWTON = Units.add(Force.class, Scalar.Force::new, unitDimension11, "N", (byte)3);
        JOULE = Units.add(Energy.class, Scalar.Energy::new, unitDimension12, "J", (byte)3);
        WATT = Units.add(Power.class, Scalar.Power::new, unitDimension13, "W", (byte)3);
        AMPERE = Units.add(ElectricCurrent.class, null, unitDimension4, "A", (byte)3);
        COULOMB = Units.add(ElectricCharge.class, null, unitDimension14, "C", (byte)3);
        VOLT = Units.add(ElectricPotential.class, null, unitDimension15, "V", (byte)3);
        FARAD = Units.add(ElectricCapacitance.class, null, unitDimension14.divide(unitDimension15), "F", (byte)3);
        SIEMENS = Units.add(ElectricConductance.class, null, unitDimension4.divide(unitDimension15), "S", (byte)3);
        OHM = Units.add(ElectricResistance.class, null, unitDimension15.divide(unitDimension4), "\u03a9", (byte)3);
        WEBER = Units.add(MagneticFlux.class, null, unitDimension16, "Wb", (byte)3);
        TESLA = Units.add(MagneticFluxDensity.class, null, unitDimension16.divide(unitDimension9), "T", (byte)3);
        HENRY = Units.add(ElectricInductance.class, null, unitDimension16.divide(unitDimension4), "H", (byte)3);
        LUX = Units.add(Illuminance.class, null, unitDimension7.divide(unitDimension9), "lx", (byte)3);
        LUMEN = Units.add(LuminousFlux.class, null, unitDimension7, "lm", (byte)3);
        CANDELA = Units.add(LuminousIntensity.class, null, unitDimension7, "cd", (byte)3);
        MOLE = Units.add(AmountOfSubstance.class, null, unitDimension6, "mol", (byte)3);
        STERADIAN = Units.add(SolidAngle.class, null, unitDimension18, "sr", (byte)3);
        PIXEL = Units.add(Dimensionless.class, Scalar.Dimensionless::new, unitDimension18, "px", (byte)16);
        PERCENT = Units.add(systemUnit9, linearConverter4, "%", (byte)16);
        PPM = Units.add(systemUnit9, linearConverter2, "ppm", (byte)16);
        ConventionalUnit<Dimensionless> conventionalUnit = Units.add(systemUnit9, PowerOf10.belToOne(), "B", (byte)5);
        DECIBEL = Units.add(conventionalUnit, Prefixes.converter('d'), "dB", (byte)4);
        UNITY = UnitRegistry.init(systemUnit9);
        UnitRegistry.alias(ARC_MINUTE, "'");
        UnitRegistry.alias(ARC_SECOND, "\"");
        UnitRegistry.alias(KELVIN, "K");
        UnitRegistry.alias(CELSIUS, "\u2103");
        UnitRegistry.alias(CELSIUS, "Cel");
        UnitRegistry.alias(FAHRENHEIT, "\u2109");
        UnitRegistry.alias(GRAD, "gon");
        UnitRegistry.alias(HECTARE, "hm\u00b2");
        UnitRegistry.alias(LITRE, "l");
        UnitRegistry.alias(LITRE, "\u2113");
        UnitRegistry.alias(UNITY, "1");
        initialized = true;
    }
}

