/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat;

import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.uom.seshat.DerivedScalar;
import tech.uom.seshat.Quantities;
import tech.uom.seshat.ScalarFactory;
import tech.uom.seshat.util.StringBuilders;

abstract class Scalar<Q extends Quantity<Q>>
extends Number
implements Quantity<Q>,
Comparable<Q> {
    private static final long serialVersionUID = -381805117700594712L;
    private final double value;
    private final Unit<Q> unit;

    Scalar(double d, Unit<Q> unit) {
        this.value = d;
        this.unit = unit;
    }

    abstract Quantity<Q> create(double var1, Unit<Q> var3);

    private Quantity<?> of(double d, Unit<?> unit) {
        if (this.unit != unit || Double.doubleToRawLongBits(this.value) != Double.doubleToRawLongBits(d)) {
            return Quantities.create(d, unit);
        }
        return this;
    }

    private Quantity<Q> of(double d) {
        if (Double.doubleToRawLongBits(this.value) != Double.doubleToRawLongBits(d)) {
            return this.create(d, this.unit);
        }
        return this;
    }

    public Unit<Q> getUnit() {
        return this.unit;
    }

    public final Number getValue() {
        return this;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public long longValue() {
        return Math.round(this.value);
    }

    @Override
    public final int intValue() {
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, this.longValue()));
    }

    @Override
    public final short shortValue() {
        return (short)Math.max(-32768L, Math.min(32767L, this.longValue()));
    }

    @Override
    public final byte byteValue() {
        return (byte)Math.max(-128L, Math.min(127L, this.longValue()));
    }

    private double doubleValue(Quantity<Q> quantity) {
        double d = quantity.getValue().doubleValue();
        Unit unit = quantity.getUnit();
        if (unit != this.unit) {
            d = unit.getConverterTo(this.unit).convert(d);
        }
        return d;
    }

    @Override
    public final int compareTo(Q q) {
        return Double.compare(this.value, this.doubleValue((Quantity<Q>)q));
    }

    public Quantity<Q> to(Unit<Q> unit) {
        if (unit == this.unit) {
            return this;
        }
        Objects.requireNonNull(unit);
        assert (this.unit.getConverterTo(this.unit.getSystemUnit()).isLinear()) : this.unit;
        UnitConverter unitConverter = this.unit.getConverterTo(unit);
        double d = unitConverter.convert(this.value);
        if (unitConverter.isLinear()) {
            return this.create(d, unit);
        }
        return Quantities.create(d, unit);
    }

    public final Quantity<Q> add(Quantity<Q> quantity) {
        return this.of(this.value + this.doubleValue(quantity));
    }

    public final Quantity<Q> subtract(Quantity<Q> quantity) {
        return this.of(this.value - this.doubleValue(quantity));
    }

    public final Quantity<Q> multiply(Number number) {
        return this.of(this.value * number.doubleValue());
    }

    public final Quantity<Q> divide(Number number) {
        return this.of(this.value / number.doubleValue());
    }

    public final Quantity<?> multiply(Quantity<?> quantity) {
        return this.of(this.value * quantity.getValue().doubleValue(), this.unit.multiply(quantity.getUnit()));
    }

    public final Quantity<?> divide(Quantity<?> quantity) {
        return this.of(this.value / quantity.getValue().doubleValue(), this.unit.divide(quantity.getUnit()));
    }

    public final Quantity<?> inverse() {
        return this.of(1.0 / this.value, this.unit.inverse());
    }

    public final <T extends Quantity<T>> Quantity<T> asType(Class<T> clazz) throws ClassCastException {
        return (Quantity)clazz.cast(this);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Scalar)) {
            if (!(object instanceof Proxy)) {
                return false;
            }
            try {
                object = Proxy.getInvocationHandler(object);
            }
            catch (IllegalArgumentException | SecurityException runtimeException) {
                return false;
            }
            if (!(object instanceof Scalar)) {
                return false;
            }
        }
        Scalar scalar = (Scalar)object;
        return Double.doubleToLongBits(this.doubleValue()) == Double.doubleToLongBits(scalar.doubleValue()) && this.getUnit().equals(scalar.getUnit());
    }

    public final int hashCode() {
        return Double.hashCode(this.doubleValue()) ^ this.getUnit().hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.doubleValue());
        StringBuilders.trimFractionalPart(stringBuilder);
        String string = this.getUnit().toString();
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(' ').append(string);
        }
        return stringBuilder.toString();
    }

    static final class Temperature
    extends Scalar<javax.measure.quantity.Temperature>
    implements javax.measure.quantity.Temperature {
        static final ScalarFactory<javax.measure.quantity.Temperature> FACTORY = new ScalarFactory<javax.measure.quantity.Temperature>(){

            @Override
            public javax.measure.quantity.Temperature create(double d, Unit<javax.measure.quantity.Temperature> unit) {
                return new Temperature(d, unit);
            }

            @Override
            public javax.measure.quantity.Temperature createDerived(double d, Unit<javax.measure.quantity.Temperature> unit, Unit<javax.measure.quantity.Temperature> unit2, UnitConverter unitConverter) {
                return new DerivedScalar.TemperatureMeasurement(d, unit, unit2, unitConverter);
            }
        };
        private static final long serialVersionUID = -6391507887931973739L;

        Temperature(double d, Unit<javax.measure.quantity.Temperature> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Temperature> create(double d, Unit<javax.measure.quantity.Temperature> unit) {
            return new Temperature(d, unit);
        }
    }

    static final class Pressure
    extends Scalar<javax.measure.quantity.Pressure>
    implements javax.measure.quantity.Pressure {
        private static final long serialVersionUID = -8647834252032382587L;

        Pressure(double d, Unit<javax.measure.quantity.Pressure> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Pressure> create(double d, Unit<javax.measure.quantity.Pressure> unit) {
            return new Pressure(d, unit);
        }
    }

    static final class Power
    extends Scalar<javax.measure.quantity.Power>
    implements javax.measure.quantity.Power {
        private static final long serialVersionUID = -5751533351918725110L;

        Power(double d, Unit<javax.measure.quantity.Power> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Power> create(double d, Unit<javax.measure.quantity.Power> unit) {
            return new Power(d, unit);
        }
    }

    static final class Energy
    extends Scalar<javax.measure.quantity.Energy>
    implements javax.measure.quantity.Energy {
        private static final long serialVersionUID = 857370990868536857L;

        Energy(double d, Unit<javax.measure.quantity.Energy> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Energy> create(double d, Unit<javax.measure.quantity.Energy> unit) {
            return new Energy(d, unit);
        }
    }

    static final class Force
    extends Scalar<javax.measure.quantity.Force>
    implements javax.measure.quantity.Force {
        private static final long serialVersionUID = -4988289861436247522L;

        Force(double d, Unit<javax.measure.quantity.Force> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Force> create(double d, Unit<javax.measure.quantity.Force> unit) {
            return new Force(d, unit);
        }
    }

    static final class Mass
    extends Scalar<javax.measure.quantity.Mass>
    implements javax.measure.quantity.Mass {
        private static final long serialVersionUID = -3348515590324141647L;

        Mass(double d, Unit<javax.measure.quantity.Mass> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Mass> create(double d, Unit<javax.measure.quantity.Mass> unit) {
            return new Mass(d, unit);
        }
    }

    static final class Speed
    extends Scalar<javax.measure.quantity.Speed>
    implements javax.measure.quantity.Speed {
        private static final long serialVersionUID = 4086187563299428546L;

        Speed(double d, Unit<javax.measure.quantity.Speed> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Speed> create(double d, Unit<javax.measure.quantity.Speed> unit) {
            return new Speed(d, unit);
        }
    }

    static final class Frequency
    extends Scalar<javax.measure.quantity.Frequency>
    implements javax.measure.quantity.Frequency {
        private static final long serialVersionUID = -2038564695278895642L;

        Frequency(double d, Unit<javax.measure.quantity.Frequency> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Frequency> create(double d, Unit<javax.measure.quantity.Frequency> unit) {
            return new Frequency(d, unit);
        }
    }

    static final class Time
    extends Scalar<javax.measure.quantity.Time>
    implements javax.measure.quantity.Time {
        private static final long serialVersionUID = 3992130757485565027L;

        Time(double d, Unit<javax.measure.quantity.Time> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Time> create(double d, Unit<javax.measure.quantity.Time> unit) {
            return new Time(d, unit);
        }
    }

    static final class Volume
    extends Scalar<javax.measure.quantity.Volume>
    implements javax.measure.quantity.Volume {
        private static final long serialVersionUID = -1505528008598251420L;

        Volume(double d, Unit<javax.measure.quantity.Volume> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Volume> create(double d, Unit<javax.measure.quantity.Volume> unit) {
            return new Volume(d, unit);
        }
    }

    static final class Area
    extends Scalar<javax.measure.quantity.Area>
    implements javax.measure.quantity.Area {
        private static final long serialVersionUID = -9127932093170175175L;

        Area(double d, Unit<javax.measure.quantity.Area> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Area> create(double d, Unit<javax.measure.quantity.Area> unit) {
            return new Area(d, unit);
        }
    }

    static final class Length
    extends Scalar<javax.measure.quantity.Length>
    implements javax.measure.quantity.Length {
        private static final long serialVersionUID = 6664029554501181657L;

        Length(double d, Unit<javax.measure.quantity.Length> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Length> create(double d, Unit<javax.measure.quantity.Length> unit) {
            return new Length(d, unit);
        }
    }

    static final class Angle
    extends Scalar<javax.measure.quantity.Angle>
    implements javax.measure.quantity.Angle {
        private static final long serialVersionUID = -1706116845342397826L;

        Angle(double d, Unit<javax.measure.quantity.Angle> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Angle> create(double d, Unit<javax.measure.quantity.Angle> unit) {
            return new Angle(d, unit);
        }
    }

    static final class Dimensionless
    extends Scalar<javax.measure.quantity.Dimensionless>
    implements javax.measure.quantity.Dimensionless {
        private static final long serialVersionUID = -7783945219314403648L;

        Dimensionless(double d, Unit<javax.measure.quantity.Dimensionless> unit) {
            super(d, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Dimensionless> create(double d, Unit<javax.measure.quantity.Dimensionless> unit) {
            return new Dimensionless(d, unit);
        }
    }
}

