/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.measure.UnitConverter;
import tech.uom.seshat.ConcatenatedConverter;
import tech.uom.seshat.IdentityConverter;
import tech.uom.seshat.math.MathFunctions;

abstract class AbstractConverter
implements UnitConverter,
Serializable {
    private static final long serialVersionUID = -8480235641759297444L;

    AbstractConverter() {
    }

    public boolean isIdentity() {
        return false;
    }

    public boolean isLinear() {
        return false;
    }

    Number[] coefficients() {
        return this.isIdentity() ? new Number[]{} : null;
    }

    public Number convert(Number number) {
        return this.convert(number.doubleValue());
    }

    public abstract double derivative(double var1);

    static double derivative(UnitConverter unitConverter, double d) {
        if (unitConverter != null) {
            if (unitConverter instanceof AbstractConverter) {
                return ((AbstractConverter)unitConverter).derivative(d);
            }
            if (unitConverter.isLinear()) {
                return unitConverter.convert(1.0) - unitConverter.convert(0.0);
            }
        }
        return Double.NaN;
    }

    static double scale(UnitConverter unitConverter) {
        if (unitConverter != null && unitConverter.isLinear() && unitConverter.convert(0.0) == 0.0) {
            return unitConverter.convert(1.0);
        }
        return Double.NaN;
    }

    static double doubleValue(Number number) {
        return number instanceof Float ? MathFunctions.floatToDouble(number.floatValue()) : number.doubleValue();
    }

    static boolean epsilonEquals(double d, double d2) {
        return Math.abs(d - d2) <= Math.scalb(Math.ulp(d), 4);
    }

    public UnitConverter concatenate(UnitConverter unitConverter) {
        if (this.equals(unitConverter.inverse())) {
            return IdentityConverter.INSTANCE;
        }
        return new ConcatenatedConverter(unitConverter, this);
    }

    public List<UnitConverter> getConversionSteps() {
        return Collections.singletonList(this);
    }
}

