/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.lib.yasson;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.serializer.JsonbSerializer;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import systems.uom.ucum.UCUM;
import tech.units.indriya.unit.Units;
import tech.uom.lib.yasson.SerializationMode;
import tech.uom.lib.yasson.UnitJsonSerializer;

public class UnitJsonSerializerTest {
    private static final String ERRORMSG_LEN = "Expected JSON with a representation of the length unit";
    private static final String ERRORMSG_AREA = "Expected JSON with a representation of the area unit";
    private static final String ERRORMSG_TEMP = "Expected JSON with a representation of the temperature unit";

    @Test
    public void testSerializeSpeedSimple() throws Exception {
        Assertions.assertEquals((Object)"\"km/h\"", (Object)this.serialize(Units.KILOMETRE_PER_HOUR), (String)"Expected JSON with a representation of the speed unit");
    }

    @Test
    public void testSerializeAreaSimple() throws Exception {
        Assertions.assertEquals((Object)"\"m\u00b2\"", (Object)this.serialize(Units.SQUARE_METRE, SerializationMode.SIMPLE), (String)ERRORMSG_AREA);
    }

    @Test
    public void testSerializeSpeedEBNF() throws Exception {
        Assertions.assertEquals((Object)"\"km/h\"", (Object)this.serialize(Units.KILOMETRE_PER_HOUR, SerializationMode.EBNF), (String)"Expected JSON with a representation of the speed unit");
    }

    @Test
    public void testSerializeAreaEBNF() throws Exception {
        Assertions.assertEquals((Object)"\"m\u00b2\"", (Object)this.serialize(Units.SQUARE_METRE, SerializationMode.EBNF), (String)ERRORMSG_AREA);
    }

    @Test
    public void testSerializeAreaUCUM() throws Exception {
        Assertions.assertEquals((Object)"\"m2\"", (Object)this.serialize(Units.SQUARE_METRE, SerializationMode.UCUM), (String)ERRORMSG_AREA);
    }

    @Test
    public void testSerializeTemperatureUCUM() throws Exception {
        Assertions.assertEquals((Object)"\"[degF]\"", (Object)this.serialize(UCUM.FAHRENHEIT, SerializationMode.UCUM), (String)ERRORMSG_TEMP);
        Assertions.assertEquals((Object)"\"Cel\"", (Object)this.serialize(Units.CELSIUS, SerializationMode.UCUM), (String)ERRORMSG_TEMP);
    }

    @Test
    public void testSerializeLengthUCUM() throws Exception {
        Assertions.assertEquals((Object)"\"[mi_i]\"", (Object)this.serialize(UCUM.MILE_INTERNATIONAL, SerializationMode.UCUM), (String)ERRORMSG_LEN);
        Assertions.assertEquals((Object)"\"m\"", (Object)this.serialize(Units.METRE, SerializationMode.UCUM), (String)ERRORMSG_LEN);
        Assertions.assertEquals((Object)"\"km\"", (Object)this.serialize(MetricPrefix.KILO((Unit)UCUM.METER), SerializationMode.UCUM), (String)ERRORMSG_LEN);
        Assertions.assertEquals((Object)"\"mm\"", (Object)this.serialize(MetricPrefix.MILLI((Unit)UCUM.METER), SerializationMode.UCUM), (String)ERRORMSG_LEN);
    }

    @Test
    public void testSerializeSpeedUCUM() throws Exception {
        Assertions.assertEquals((Object)"\"[kph]\"", (Object)this.serialize(Units.KILOMETRE_PER_HOUR, SerializationMode.UCUM), (String)"Expected JSON with a representation of the speed unit");
    }

    private String serialize(Object objectToSerialize, SerializationMode mode) throws IOException {
        JsonbConfig config = new JsonbConfig().withSerializers(new JsonbSerializer[]{UnitJsonSerializer.ofMode((SerializationMode)mode)});
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        StringWriter writer = new StringWriter();
        jsonb.toJson(objectToSerialize, (Writer)writer);
        return ((Object)writer).toString();
    }

    private String serialize(Object object) throws IOException {
        return this.serialize(object, SerializationMode.SIMPLE);
    }
}

