/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.lib.yasson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.measure.Unit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import systems.uom.ucum.UCUM;
import tech.units.indriya.unit.Units;
import tech.uom.lib.yasson.SerializationMode;
import tech.uom.lib.yasson.UnitJsonDeserializer;

public class UnitJsonDeserializerTest {
    private static final String ERRMSG_PARSE_LEN = "The Unit<Length> in the JSON doesn't match";
    private static final String ERRMSG_PARSE_MASS = "The Unit<Mass> in the JSON doesn't match";

    @Test
    public void testSimple() throws IOException {
        JsonbConfig config = new JsonbConfig().withFormatting(Boolean.valueOf(true)).withDeserializers(new JsonbDeserializer[]{new UnitJsonDeserializer()});
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        ByteArrayInputStream stream = new ByteArrayInputStream("{\"unit\":\"m\"}".getBytes(StandardCharsets.UTF_8));
        Unit result = (Unit)jsonb.fromJson((InputStream)stream, Unit.class);
        Assertions.assertEquals((Object)Units.METRE, (Object)result, (String)ERRMSG_PARSE_LEN);
    }

    @Test
    public void testEBNF() throws IOException {
        JsonbConfig config = new JsonbConfig().withFormatting(Boolean.valueOf(true)).withDeserializers(new JsonbDeserializer[]{UnitJsonDeserializer.ofMode((SerializationMode)SerializationMode.EBNF)});
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        ByteArrayInputStream stream = new ByteArrayInputStream("{\"unit\":\"kg\"}".getBytes(StandardCharsets.UTF_8));
        Unit result = (Unit)jsonb.fromJson((InputStream)stream, Unit.class);
        Assertions.assertEquals((Object)Units.KILOGRAM, (Object)result, (String)ERRMSG_PARSE_MASS);
    }

    @Test
    public void testUCUM() throws IOException {
        JsonbConfig config = new JsonbConfig().withFormatting(Boolean.valueOf(true)).withDeserializers(new JsonbDeserializer[]{UnitJsonDeserializer.ofMode((SerializationMode)SerializationMode.UCUM)});
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        ByteArrayInputStream stream = new ByteArrayInputStream("{\"unit\":\"[ly]\"}".getBytes(StandardCharsets.UTF_8));
        Unit result = (Unit)jsonb.fromJson((InputStream)stream, Unit.class);
        Assertions.assertEquals((Object)UCUM.LIGHT_YEAR, (Object)result, (String)ERRMSG_PARSE_LEN);
    }
}

