/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.lib.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.measure.Unit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import systems.uom.ucum.UCUM;
import tec.units.indriya.AbstractUnit;
import tec.units.indriya.unit.MetricPrefix;
import tec.units.indriya.unit.Units;
import tech.uom.lib.jackson.UnitJacksonModule;

public class TestUnitJacksonModule {
    private JsonFactory jsonFactory;

    @Before
    public void setUp() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new UnitJacksonModule());
        this.jsonFactory = new JsonFactory((ObjectCodec)mapper);
    }

    @Test
    public void testSerializeArea() throws Exception {
        Assert.assertEquals((String)"Expected JSON with a UCUM representation of the area unit", (Object)"\"m2\"", (Object)this.serialize(Units.SQUARE_METRE));
    }

    @Test
    public void testSerializeTemperature() throws Exception {
        Assert.assertEquals((String)"Expected JSON with a UCUM representation of the temperature unit", (Object)"\"[degF]\"", (Object)this.serialize(UCUM.FAHRENHEIT));
        Assert.assertEquals((String)"Expected JSON with a UCUM representation of the temperature unit", (Object)"\"Cel\"", (Object)this.serialize(Units.CELSIUS));
    }

    @Test
    public void testSerializeLength() throws Exception {
        Assert.assertEquals((String)"Expected JSON with a UCUM representation of the length unit", (Object)"\"[mi_i]\"", (Object)this.serialize(UCUM.MILE_INTERNATIONAL));
        Assert.assertEquals((String)"Expected JSON with a UCUM representation of the length unit", (Object)"\"m\"", (Object)this.serialize(Units.METRE));
        Assert.assertEquals((String)"Expected JSON with a UCUM representation of the length unit", (Object)"\"km\"", (Object)this.serialize(MetricPrefix.KILO((Unit)UCUM.METER)));
        Assert.assertEquals((String)"Expected JSON with a UCUM representation of the length unit", (Object)"\"mm\"", (Object)this.serialize(MetricPrefix.MILLI((Unit)UCUM.METER)));
    }

    @Test
    public void testSerializeSpeed() throws Exception {
        Assert.assertEquals((String)"Expected JSON with a UCUM representation of the speed unit", (Object)"\"[kph]\"", (Object)this.serialize(Units.KILOMETRE_PER_HOUR));
    }

    @Test
    public void testParseArea() throws Exception {
        Unit parsedUnit = this.parse("\"[sft_i]\"", Unit.class);
        Assert.assertEquals((String)"The Unit<Area> in the parsed JSON doesn't match", (Object)UCUM.SQUARE_FOOT_INTERNATIONAL, (Object)parsedUnit);
    }

    @Test
    public void testParseTemperature() throws Exception {
        Unit parsedUnit = this.parse("\"Cel\"", Unit.class);
        Assert.assertEquals((String)"The Unit<Temperature> in the parsed JSON doesn't match", (Object)Units.CELSIUS, (Object)parsedUnit);
    }

    @Test
    public void testParseTemperatureInverse() throws Exception {
        Unit parsedUnit = this.parse("\"1/K\"", Unit.class);
        Assert.assertEquals((String)"The Unit<Temperature> in the parsed JSON doesn't match", (Object)AbstractUnit.ONE.divide(Units.KELVIN), (Object)parsedUnit);
    }

    @Test
    public void testParseLength() throws Exception {
        Unit parsedUnit = this.parse("\"m\"", Unit.class);
        Assert.assertEquals((String)"The Unit<Length> in the parsed JSON doesn't match", (Object)Units.METRE, (Object)parsedUnit);
    }

    @Test(expected=JsonParseException.class)
    public void testParseWithUnrecognizedField() throws Exception {
        this.parse("foobar", Unit.class);
    }

    @Test
    @Ignore(value="solve km formatting")
    public void testParseLengthKm() throws Exception {
        Unit parsedUnit = this.parse("\"km\"", Unit.class);
        Assert.assertEquals((String)"The Unit<Length> in the parsed JSON doesn't match", (Object)MetricPrefix.KILO((Unit)Units.METRE), (Object)parsedUnit);
    }

    protected String serialize(Object objectToSerialize) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = this.jsonFactory.createJsonGenerator((Writer)writer);
        generator.writeObject(objectToSerialize);
        generator.close();
        return ((Object)writer).toString();
    }

    protected <T> T parse(String json, Class<T> aClass) throws IOException {
        JsonParser parser = this.jsonFactory.createJsonParser(json);
        Object object = parser.readValueAs(aClass);
        parser.close();
        return (T)object;
    }
}

