package tech.uom.lib.assertj.assertions;

import javax.measure.Unit;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Unit} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractUnitAssert<S extends AbstractUnitAssert<S, A>, A extends Unit> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractUnitAssert}</code> to make assertions on actual Unit.
   * @param actual the Unit we want to make assertions on.
   */
  protected AbstractUnitAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Unit's baseUnits is equal to the given one.
   * @param baseUnits the given baseUnits to compare the actual Unit's baseUnits to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Unit's baseUnits is not equal to the given one.
   */
  public S hasBaseUnits(java.util.Map baseUnits) {
    // check that actual Unit we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting baseUnits of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualBaseUnits = actual.getBaseUnits();
    if (!Objects.areEqual(actualBaseUnits, baseUnits)) {
      failWithMessage(assertjErrorMessage, actual, baseUnits, actualBaseUnits);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Unit's dimension is equal to the given one.
   * @param dimension the given dimension to compare the actual Unit's dimension to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Unit's dimension is not equal to the given one.
   */
  public S hasDimension(javax.measure.Dimension dimension) {
    // check that actual Unit we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dimension of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    javax.measure.Dimension actualDimension = actual.getDimension();
    if (!Objects.areEqual(actualDimension, dimension)) {
      failWithMessage(assertjErrorMessage, actual, dimension, actualDimension);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Unit's name is equal to the given one.
   * @param name the given name to compare the actual Unit's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Unit's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual Unit we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Unit's symbol is equal to the given one.
   * @param symbol the given symbol to compare the actual Unit's symbol to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Unit's symbol is not equal to the given one.
   */
  public S hasSymbol(String symbol) {
    // check that actual Unit we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting symbol of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualSymbol = actual.getSymbol();
    if (!Objects.areEqual(actualSymbol, symbol)) {
      failWithMessage(assertjErrorMessage, actual, symbol, actualSymbol);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Unit's systemUnit is equal to the given one.
   * @param systemUnit the given systemUnit to compare the actual Unit's systemUnit to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Unit's systemUnit is not equal to the given one.
   */
  public S hasSystemUnit(javax.measure.Unit systemUnit) {
    // check that actual Unit we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting systemUnit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    javax.measure.Unit actualSystemUnit = actual.getSystemUnit();
    if (!Objects.areEqual(actualSystemUnit, systemUnit)) {
      failWithMessage(assertjErrorMessage, actual, systemUnit, actualSystemUnit);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
