package tech.uom.lib.assertj.assertions;

import javax.measure.Dimension;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Dimension} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractDimensionAssert<S extends AbstractDimensionAssert<S, A>, A extends Dimension> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDimensionAssert}</code> to make assertions on actual Dimension.
   * @param actual the Dimension we want to make assertions on.
   */
  protected AbstractDimensionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Dimension's baseDimensions is equal to the given one.
   * @param baseDimensions the given baseDimensions to compare the actual Dimension's baseDimensions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Dimension's baseDimensions is not equal to the given one.
   */
  public S hasBaseDimensions(java.util.Map baseDimensions) {
    // check that actual Dimension we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting baseDimensions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualBaseDimensions = actual.getBaseDimensions();
    if (!Objects.areEqual(actualBaseDimensions, baseDimensions)) {
      failWithMessage(assertjErrorMessage, actual, baseDimensions, actualBaseDimensions);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
