/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.unit;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import tech.uom.impl.enums.unit.SimpleDimension;
import tech.uom.lib.common.function.DoubleFactorSupplier;

public enum TimeUnit implements Unit<Time>,
DoubleFactorSupplier
{
    SECOND("s", 1.0),
    MINUTE("m", 60.0),
    HOUR("h", 3600.0),
    MILLISECOND("ms", 0.001);

    private final String symbol;
    private final double multFactor;

    private TimeUnit(String s, double multF) {
        this.symbol = s;
        this.multFactor = multF;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name();
    }

    public double getFactor() {
        return this.multFactor;
    }

    public Unit<Time> getSystemUnit() {
        return SECOND;
    }

    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        HashMap<TimeUnit, Integer> prodUnits = new HashMap<TimeUnit, Integer>();
        prodUnits.put(HOUR, 2);
        return prodUnits;
    }

    public static TimeUnit getBySymbol(String symbol) {
        if (HOUR.name().equals(symbol)) {
            return HOUR;
        }
        if (MINUTE.name().equals(symbol)) {
            return MINUTE;
        }
        return SECOND;
    }

    public UnitConverter getConverterTo(Unit<Time> that) throws UnconvertibleException {
        return null;
    }

    public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        return null;
    }

    public Unit<Time> alternate(String s) {
        return this;
    }

    public Dimension getDimension() {
        return SimpleDimension.INSTANCE;
    }

    public Unit<?> inverse() {
        return this;
    }

    public Unit<Time> divide(double v) {
        return null;
    }

    public Unit<?> divide(Unit<?> unit) {
        return null;
    }

    public boolean isCompatible(Unit<?> that) {
        return that instanceof TimeUnit;
    }

    public <T extends Quantity<T>> Unit<T> asType(Class<T> tClass) {
        Unit<Time> metricUnit = this.getSystemUnit();
        if (metricUnit == null || metricUnit.isCompatible((Unit)this)) {
            return this;
        }
        throw new ClassCastException("The unit: " + (Object)((Object)this) + " is not of parameterized type " + tClass);
    }

    public Unit<Time> multiply(double factor) {
        for (TimeUnit tu : TimeUnit.values()) {
            if (tu.getFactor() != factor) continue;
            return tu;
        }
        return this;
    }

    public Unit<?> multiply(Unit<?> that) {
        return this;
    }

    public Unit<?> pow(int n) {
        return this;
    }

    public Unit<?> root(int n) {
        return this;
    }

    public Unit<Time> transform(UnitConverter operation) {
        return this;
    }

    public Unit<Time> shift(double v) {
        return this;
    }

    public Unit<Time> prefix(Prefix prefix) {
        return this.multiply(Math.pow(prefix.getValue().doubleValue(), prefix.getExponent()));
    }

    public Unit<Time> shift(Number offset) {
        return this;
    }

    public Unit<Time> multiply(Number multiplier) {
        return this;
    }

    public Unit<Time> divide(Number divisor) {
        return this;
    }

    public boolean isEquivalentTo(Unit<Time> that) {
        return this.equals(that);
    }
}

