/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.unit;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Temperature;
import tech.uom.impl.enums.DimensionalModel;
import tech.uom.impl.enums.function.AbstractConverter;
import tech.uom.impl.enums.unit.SimpleDimension;
import tech.uom.lib.common.function.DescriptionSupplier;
import tech.uom.lib.common.function.DoubleFactorSupplier;

public enum TemperatureUnit implements Unit<Temperature>,
DoubleFactorSupplier,
DescriptionSupplier
{
    KELVIN(1.0, 0.0, null, 273.15, 373.15, "K", "William Thomson, 1st Baron Kelvin"),
    RANKINE(0.0, 0.0, KELVIN, 491.67, 671.641, "\u00b0R", "William John Macquorn Rankine"),
    CELSIUS(0.0, 273.15, KELVIN, 0.0, 100.0, "\u00b0C", "Anders Celsius"),
    FAHRENHEIT(0.0, 459.67, RANKINE, 32.0, 212.0, "\u00b0F", "Daniel Gabriel Fahrenheit");

    private final String description;
    private final double multFactor;
    private final double freezingPoint;
    private final double boilingPoint;
    private final String namedFor;
    private final TemperatureUnit relativeTo;
    private static final double RANKINE_FAHRENHEIT_DELTA = 459.67;

    private TemperatureUnit(double newMult, double shift, TemperatureUnit rel, double newFreezingPoint, double newBoilingPoint, String newSymbol, String newNamedFor) {
        this.multFactor = newMult;
        this.relativeTo = rel;
        this.freezingPoint = newFreezingPoint;
        this.boilingPoint = newBoilingPoint;
        this.description = newSymbol;
        this.namedFor = newNamedFor;
    }

    public String getSymbol() {
        return this.description;
    }

    public double getFactor() {
        return this.multFactor;
    }

    public String getName() {
        return this.namedFor;
    }

    public Unit<Temperature> getSystemUnit() {
        return KELVIN;
    }

    public Map<? extends Unit<Temperature>, Integer> getBaseUnits() {
        HashMap<TemperatureUnit, Integer> prodUnits = new HashMap<TemperatureUnit, Integer>();
        prodUnits.put(KELVIN, 2);
        return prodUnits;
    }

    public static TemperatureUnit getBySymbol(String symbol) {
        if (CELSIUS.name().equals(symbol)) {
            return CELSIUS;
        }
        if (FAHRENHEIT.name().equals(symbol)) {
            return FAHRENHEIT;
        }
        return KELVIN;
    }

    public UnitConverter getConverterTo(Unit<Temperature> that) throws UnconvertibleException {
        Unit thatSystemUnit;
        if (this == that || this.equals(that)) {
            return AbstractConverter.IDENTITY;
        }
        Unit<Temperature> thisSystemUnit = this.getSystemUnit();
        if (!thisSystemUnit.equals((Object)(thatSystemUnit = that.getSystemUnit()))) {
            try {
                return this.getConverterToAny(that);
            }
            catch (IncommensurableException e) {
                throw new UnconvertibleException((Throwable)e);
            }
        }
        return that.getConverterTo(thatSystemUnit);
    }

    public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        if (!this.isCompatible(that)) {
            throw new IncommensurableException((Object)((Object)this) + " is not compatible with " + that);
        }
        DimensionalModel model = DimensionalModel.current();
        return model.getDimensionalTransform(this.getSystemUnit().getDimension());
    }

    public Unit<Temperature> alternate(String s) {
        return this;
    }

    public Dimension getDimension() {
        return SimpleDimension.INSTANCE;
    }

    public Unit<?> inverse() {
        return this;
    }

    public Unit<Temperature> divide(double v) {
        return null;
    }

    public Unit<?> divide(Unit<?> unit) {
        return null;
    }

    public boolean isCompatible(Unit<?> that) {
        return that instanceof TemperatureUnit;
    }

    public final <T extends Quantity<T>> Unit<T> asType(Class<T> type) {
        Unit<Temperature> metricUnit = this.getSystemUnit();
        if (metricUnit == null || metricUnit.isCompatible((Unit)this)) {
            return this;
        }
        throw new ClassCastException("The unit: " + (Object)((Object)this) + " is not of parameterized type " + type);
    }

    public Unit<Temperature> multiply(double factor) {
        return this;
    }

    public Unit<?> multiply(Unit<?> that) {
        return this;
    }

    public Unit<?> pow(int n) {
        return this;
    }

    public Unit<?> root(int n) {
        return this;
    }

    public Unit<Temperature> transform(UnitConverter operation) {
        return this;
    }

    public Unit<Temperature> shift(double v) {
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Unit<Temperature> prefix(Prefix prefix) {
        return this.multiply(Math.pow(prefix.getValue().doubleValue(), prefix.getExponent()));
    }

    public Unit<Temperature> shift(Number offset) {
        return this;
    }

    public Unit<Temperature> multiply(Number multiplier) {
        return this;
    }

    public Unit<Temperature> divide(Number divisor) {
        return this;
    }

    public boolean isEquivalentTo(Unit<Temperature> that) {
        return this.equals(that);
    }
}

