/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.unit;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.uom.impl.enums.format.SimpleUnitFormat;

public final class MixedUnit<Q extends Quantity<Q>>
implements Unit<Q> {
    private final Unit<Q> upper;
    private final Unit<Q> lower;

    public MixedUnit(Unit<Q> up, Unit<Q> low) {
        if (!up.getSystemUnit().equals(low.getSystemUnit())) {
            throw new IllegalArgumentException("Both units do not have the same system unit");
        }
        this.upper = up;
        this.lower = low;
    }

    public Unit<Q> getLower() {
        return this.lower;
    }

    public Unit<Q> getUpper() {
        return this.upper;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MixedUnit) {
            MixedUnit thatUnit = (MixedUnit)obj;
            return this.upper.equals(thatUnit.upper) && this.lower.equals(thatUnit.lower);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.upper.hashCode() ^ this.lower.hashCode();
    }

    public Unit<Q> getSystemUnit() {
        return this.lower.getSystemUnit();
    }

    public Dimension getDimension() {
        return this.lower.getDimension();
    }

    public String getSymbol() {
        return this.upper.getSymbol() + ":" + this.lower.getSymbol();
    }

    public String getName() {
        return this.upper.getName() + ":" + this.lower.getName();
    }

    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return null;
    }

    public boolean isCompatible(Unit<?> that) {
        return false;
    }

    public <T extends Quantity<T>> Unit<T> asType(Class<T> type) throws ClassCastException {
        return null;
    }

    public UnitConverter getConverterTo(Unit<Q> that) throws UnconvertibleException {
        return null;
    }

    public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        return null;
    }

    public Unit<Q> alternate(String symbol) {
        return null;
    }

    public Unit<Q> shift(double offset) {
        return null;
    }

    public Unit<Q> multiply(double multiplier) {
        return null;
    }

    public Unit<?> multiply(Unit<?> multiplier) {
        return null;
    }

    public Unit<?> inverse() {
        return this;
    }

    public Unit<Q> divide(double divisor) {
        return this;
    }

    public Unit<?> divide(Unit<?> divisor) {
        return this;
    }

    public Unit<?> root(int n) {
        return this;
    }

    public Unit<?> pow(int n) {
        return this;
    }

    public Unit<Q> transform(UnitConverter operation) {
        return this;
    }

    public Unit<Q> prefix(Prefix prefix) {
        return this.multiply(Math.pow(prefix.getValue().doubleValue(), prefix.getExponent()));
    }

    public Unit<Q> mix(Unit<Q> that) {
        return new MixedUnit<Q>(this, that);
    }

    public String toString() {
        return SimpleUnitFormat.getInstance().format((Unit)this);
    }

    public Unit<Q> shift(Number offset) {
        return this;
    }

    public Unit<Q> multiply(Number multiplier) {
        return this;
    }

    public Unit<Q> divide(Number divisor) {
        return this;
    }

    public boolean isEquivalentTo(Unit<Q> that) {
        return this.equals(that);
    }
}

