/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.unit;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import tech.uom.impl.enums.unit.SimpleDimension;
import tech.uom.lib.common.function.DoubleFactorSupplier;
import tech.uom.lib.common.util.DescriptiveEnum;

public enum DistanceUnit implements Unit<Length>,
DoubleFactorSupplier,
DescriptiveEnum<DistanceUnit>
{
    METRE("m", "m", 1.0),
    KILOMETRE("km", "km", 1000.0);

    private final String symbol;
    private final String description;
    private final double multFactor;

    private DistanceUnit(String symbol, String name, double multF) {
        this.symbol = symbol;
        this.description = name;
        this.multFactor = multF;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public double getFactor() {
        return this.multFactor;
    }

    public Unit<Length> getSystemUnit() {
        return METRE;
    }

    public String getName() {
        return this.name();
    }

    public Map<? extends Unit<Length>, Integer> getBaseUnits() {
        HashMap<DistanceUnit, Integer> prodUnits = new HashMap<DistanceUnit, Integer>();
        prodUnits.put(KILOMETRE, 3);
        return prodUnits;
    }

    public static DistanceUnit getBySymbol(String symbol) {
        if (KILOMETRE.getSymbol().equals(symbol)) {
            return KILOMETRE;
        }
        return METRE;
    }

    public UnitConverter getConverterTo(Unit<Length> that) throws UnconvertibleException {
        return null;
    }

    public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        return null;
    }

    public Unit<Length> alternate(String s) {
        return null;
    }

    public Dimension getDimension() {
        return SimpleDimension.INSTANCE;
    }

    public Unit<?> inverse() {
        return this;
    }

    public Unit<Length> divide(double v) {
        return null;
    }

    public Unit<?> divide(Unit<?> unit) {
        return null;
    }

    public boolean isCompatible(Unit<?> that) {
        return that instanceof DistanceUnit;
    }

    public <T extends Quantity<T>> Unit<T> asType(Class<T> tClass) {
        DistanceUnit metricUnit = METRE;
        if (metricUnit == null || metricUnit.isCompatible(this)) {
            return this;
        }
        throw new ClassCastException("The unit: " + (Object)((Object)this) + " is not of parameterized type " + tClass);
    }

    public Unit<Length> multiply(double factor) {
        return this;
    }

    public Unit<?> multiply(Unit<?> that) {
        return this;
    }

    public Unit<?> pow(int n) {
        return this;
    }

    public Unit<?> root(int n) {
        return this;
    }

    public Unit<Length> transform(UnitConverter operation) {
        return this;
    }

    public Unit<Length> shift(double v) {
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public DescriptiveEnum<DistanceUnit>[] dValues() {
        return DistanceUnit.values();
    }

    public Unit<Length> prefix(Prefix prefix) {
        return this.multiply(Math.pow(prefix.getValue().doubleValue(), prefix.getExponent()));
    }

    public Unit<Length> shift(Number offset) {
        return this;
    }

    public Unit<Length> multiply(Number multiplier) {
        return this;
    }

    public Unit<Length> divide(Number divisor) {
        return this;
    }

    public boolean isEquivalentTo(Unit<Length> that) {
        return this.equals(that);
    }
}

