/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.unit;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import tech.uom.impl.enums.unit.SimpleDimension;
import tech.uom.lib.common.function.DoubleFactorSupplier;

public enum DimensionlessUnit implements Unit<Dimensionless>,
DoubleFactorSupplier
{
    ONE("", 1.0);

    private final String description;
    private final double multFactor;

    private DimensionlessUnit(String name, double multF) {
        this.description = name;
        this.multFactor = multF;
    }

    public String getSymbol() {
        return this.description;
    }

    public double getFactor() {
        return this.multFactor;
    }

    public Unit<Dimensionless> getSystemUnit() {
        return ONE;
    }

    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        HashMap<DimensionlessUnit, Integer> prodUnits = new HashMap<DimensionlessUnit, Integer>();
        prodUnits.put(ONE, 1);
        return prodUnits;
    }

    public static DimensionlessUnit getByName(String symbol) {
        return ONE;
    }

    public UnitConverter getConverterTo(Unit<Dimensionless> that) throws UnconvertibleException {
        return null;
    }

    public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        return null;
    }

    public Unit<Dimensionless> alternate(String s) {
        return null;
    }

    public String getName() {
        return this.name();
    }

    public Dimension getDimension() {
        return SimpleDimension.INSTANCE;
    }

    public Unit<?> inverse() {
        return this;
    }

    public Unit<Dimensionless> divide(double v) {
        return null;
    }

    public Unit<?> divide(Unit<?> unit) {
        return null;
    }

    public boolean isCompatible(Unit<?> that) {
        return that instanceof DimensionlessUnit;
    }

    public <T extends Quantity<T>> Unit<T> asType(Class<T> tClass) {
        DimensionlessUnit metricUnit = ONE;
        if (metricUnit == null || metricUnit.isCompatible(this)) {
            return this;
        }
        throw new ClassCastException("The unit: " + (Object)((Object)this) + " is not of parameterized type " + tClass);
    }

    public Unit<Dimensionless> multiply(double factor) {
        return this;
    }

    public Unit<?> multiply(Unit<?> that) {
        return this;
    }

    public Unit<?> pow(int n) {
        return this;
    }

    public Unit<?> root(int n) {
        return this;
    }

    public Unit<Dimensionless> transform(UnitConverter operation) {
        return this;
    }

    public Unit<Dimensionless> shift(double v) {
        return this;
    }

    public Unit<Dimensionless> prefix(Prefix prefix) {
        return this.multiply(Math.pow(prefix.getValue().doubleValue(), prefix.getExponent()));
    }

    public Unit<Dimensionless> shift(Number v) {
        return this;
    }

    public Unit<Dimensionless> multiply(Number multiplier) {
        return this;
    }

    public Unit<Dimensionless> divide(Number divisor) {
        return this;
    }

    public boolean isEquivalentTo(Unit<Dimensionless> that) {
        return this.equals(that);
    }
}

