/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.quantity;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import tech.uom.impl.enums.AbstractQuantity;
import tech.uom.impl.enums.format.UnitStyle;
import tech.uom.impl.enums.unit.TimeUnit;

public class TimeQuantity
extends AbstractQuantity<Time>
implements Time {
    private final double scalar;
    private final Double value;
    private final TimeUnit unit;

    public TimeQuantity(Number val, TimeUnit un) {
        this.value = val.doubleValue();
        this.unit = un;
        this.scalar = val != null && un != null ? val.doubleValue() * un.getFactor() : Double.NaN;
    }

    public TimeQuantity(Number val, Unit un) {
        this((Number)val.doubleValue(), (TimeUnit)un);
    }

    @Override
    public boolean isZero() {
        return this.value != null && 0.0 == this.value;
    }

    public TimeQuantity add(TimeQuantity d1) {
        TimeQuantity dn = new TimeQuantity((Number)(this.value + d1.value), this.unit);
        return dn;
    }

    public TimeQuantity subtract(TimeQuantity d1) {
        TimeQuantity dn = new TimeQuantity((Number)(this.value - d1.value), this.unit);
        return dn;
    }

    public boolean eq(TimeQuantity dq) {
        return dq != null && dq.getValue().equals(this.getValue()) && dq.getUnit().equals(this.getUnit()) && dq.getScalar().equals(this.getScalar());
    }

    public boolean ne(TimeQuantity d1) {
        return this.ne(d1);
    }

    public boolean gt(TimeQuantity d1) {
        return this.gt(d1);
    }

    public boolean lt(TimeQuantity d1) {
        return this.lt(d1);
    }

    public boolean ge(TimeQuantity d1) {
        return this.ge(d1);
    }

    public boolean le(TimeQuantity d1) {
        return this.le(d1);
    }

    public TimeQuantity divide(Double v) {
        return new TimeQuantity((Number)(this.value / v), this.unit);
    }

    protected TimeQuantity convert(TimeUnit newUnit) {
        return new TimeQuantity((Number)(this.value * (this.unit.getFactor() / newUnit.getFactor())), newUnit);
    }

    @Override
    public Number getScalar() {
        return this.scalar;
    }

    @Override
    public String toString(boolean withUnit, boolean withSpace, int precision) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getValue());
        if (withUnit) {
            if (withSpace) {
                sb.append(" ");
            }
            sb.append(this.getUnit().getSymbol());
        }
        return sb.toString();
    }

    @Override
    public String showInUnit(Unit<?> u, int precision, UnitStyle style) {
        return this.showInUnit(u, this.value, precision, style);
    }

    public Number getValue() {
        return this.value;
    }

    public Unit<Time> getUnit() {
        return this.unit;
    }

    public Quantity<Time> multiply(Number that) {
        return new TimeQuantity((Number)(this.value * that.doubleValue()), this.unit);
    }

    public Quantity<Time> to(Unit<Time> unit) {
        if (unit instanceof TimeUnit) {
            return this.convert((TimeUnit)unit);
        }
        throw new ArithmeticException("Cannot convert " + (Object)((Object)this.unit) + " to " + unit);
    }

    @Override
    public boolean eq(AbstractQuantity<Time> dq) {
        return this.eq((TimeQuantity)dq);
    }

    public Quantity<?> divide(Quantity<?> that) {
        return null;
    }

    public Quantity<Time> subtract(Quantity<Time> that) {
        return null;
    }

    public Quantity<Time> add(Quantity<Time> that) {
        return null;
    }

    public Quantity<Time> divide(Number that) {
        return null;
    }

    public Quantity<Time> inverse() {
        return null;
    }

    public Quantity<?> multiply(Quantity<?> that) {
        return new TimeQuantity((Number)(this.value * that.getValue().doubleValue()), this.unit);
    }

    @Override
    public int compareTo(Quantity<Time> o) {
        return 0;
    }

    public Quantity<Time> negate() {
        return new TimeQuantity((Number)(-this.value.doubleValue()), this.unit);
    }
}

