/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.quantity;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Temperature;
import tech.uom.impl.enums.AbstractQuantity;
import tech.uom.impl.enums.format.UnitStyle;
import tech.uom.impl.enums.unit.TemperatureUnit;

public final class TemperatureQuantity
extends AbstractQuantity<Temperature>
implements Temperature {
    private final Double scalar;
    private final double value;
    private final TemperatureUnit unit;

    public TemperatureQuantity(double val, TemperatureUnit un) {
        super(TemperatureUnit.KELVIN.equals((Object)un) ? Quantity.Scale.ABSOLUTE : Quantity.Scale.RELATIVE);
        this.unit = un;
        this.value = val;
        this.scalar = un != null ? Double.valueOf(val * un.getFactor()) : null;
    }

    public TemperatureQuantity(Number val, Unit u) {
        this(val.doubleValue(), (TemperatureUnit)u);
    }

    @Override
    public boolean isZero() {
        return 0.0 == this.value;
    }

    public TemperatureQuantity add(TemperatureQuantity d1) {
        TemperatureQuantity dn = new TemperatureQuantity((Number)(this.value + d1.value), (Unit)this.unit);
        return dn;
    }

    public TemperatureQuantity subtract(TemperatureQuantity d1) {
        TemperatureQuantity dn = new TemperatureQuantity(this.value - d1.value, this.unit);
        return dn;
    }

    protected boolean eq(TemperatureQuantity dq) {
        return dq != null && dq.getValue().equals(this.getValue()) && dq.getUnit().equals(this.getUnit()) && dq.getScalar().equals(this.getScalar());
    }

    boolean ne(TemperatureQuantity d1) {
        return this.ne(d1);
    }

    boolean gt(TemperatureQuantity d1) {
        return this.gt(d1);
    }

    public boolean lt(TemperatureQuantity d1) {
        return this.lt(d1);
    }

    public boolean ge(TemperatureQuantity d1) {
        return this.ge(d1);
    }

    public boolean le(TemperatureQuantity d1) {
        return this.le(d1);
    }

    public TemperatureQuantity divide(double v) {
        return new TemperatureQuantity(this.value / v, this.unit);
    }

    protected TemperatureQuantity convert(TemperatureUnit newUnit) {
        return new TemperatureQuantity(this.value / newUnit.getFactor(), newUnit);
    }

    @Override
    public Double getScalar() {
        return this.scalar;
    }

    @Override
    public String toString(boolean withUnit, boolean withSpace, int precision) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getValue());
        if (withUnit) {
            if (withSpace) {
                sb.append(" ");
            }
            sb.append(this.getUnit().getSymbol());
        }
        return sb.toString();
    }

    @Override
    public String showInUnit(Unit<?> u, int precision, UnitStyle style) {
        return this.showInUnit(u, this.value, precision, style);
    }

    public Number getValue() {
        return this.value;
    }

    public Unit<Temperature> getUnit() {
        return this.unit;
    }

    public Quantity<Temperature> multiply(Number that) {
        return new TemperatureQuantity(this.value * that.doubleValue(), this.unit);
    }

    public Quantity<?> multiply(Quantity<?> that) {
        return new TemperatureQuantity(this.value * that.getValue().doubleValue(), this.unit);
    }

    public Quantity<Temperature> inverse() {
        return null;
    }

    protected double doubleValue(Unit<Temperature> unit) {
        Unit<Temperature> myUnit = this.getUnit();
        UnitConverter converter = unit.getConverterTo(myUnit);
        return converter.convert(this.getValue().doubleValue());
    }

    public Quantity<Temperature> to(Unit<Temperature> unit) {
        if (this.unit.equals(unit)) {
            return this;
        }
        if (unit instanceof TemperatureUnit) {
            return this.convert((TemperatureUnit)unit);
        }
        throw new ArithmeticException("Cannot convert " + (Object)((Object)this.unit) + " to " + unit);
    }

    @Override
    protected boolean eq(AbstractQuantity<Temperature> dq) {
        return this.eq((TemperatureQuantity)dq);
    }

    public Quantity<?> divide(Quantity<?> that) {
        return null;
    }

    public Quantity<Temperature> subtract(Quantity<Temperature> that) {
        return null;
    }

    public Quantity<Temperature> add(Quantity<Temperature> that) {
        return null;
    }

    public Quantity<Temperature> divide(Number that) {
        return null;
    }

    @Override
    public int compareTo(Quantity<Temperature> o) {
        return 0;
    }

    public Quantity<Temperature> negate() {
        return new TemperatureQuantity(-this.value, this.unit);
    }
}

