/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.quantity;

import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.uom.impl.enums.quantity.DimensionlessQuantity;
import tech.uom.impl.enums.quantity.TemperatureQuantity;
import tech.uom.impl.enums.quantity.TimeQuantity;
import tech.uom.impl.enums.unit.TimeUnit;

public final class Quantities {
    private Quantities() {
    }

    public static <Q extends Quantity<Q>> Quantity<Q> getQuantity(Number value, Unit<Q> unit) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(unit);
        if (TemperatureQuantity.class.isInstance(unit)) {
            return new TemperatureQuantity(value, unit);
        }
        if (TimeUnit.class.isInstance(unit)) {
            return new TimeQuantity(value, unit);
        }
        return new DimensionlessQuantity(value, unit);
    }
}

