/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.format;

import java.io.IOException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.format.UnitFormat;
import tech.uom.impl.enums.format.AbstractUnitFormat;
import tech.uom.impl.enums.unit.DimensionlessUnit;
import tech.uom.impl.enums.unit.DistanceUnit;
import tech.uom.impl.enums.unit.MixedUnit;

public class SimpleUnitFormat
extends AbstractUnitFormat {
    private final Map<String, String> symbolMap = new HashMap<String, String>();
    private static final Map<String, Unit<?>> unitMap = new HashMap();
    private static final UnitFormat DEFAULT = new SimpleUnitFormat();

    public static UnitFormat getInstance() {
        return DEFAULT;
    }

    SimpleUnitFormat() {
        unitMap.put("m", DistanceUnit.METRE);
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        if (unit instanceof MixedUnit) {
            MixedUnit cpdUnit = (MixedUnit)unit;
            StringBuilder mixable = new StringBuilder();
            mixable.append(cpdUnit.getUpper().getSymbol());
            mixable.append(":");
            mixable.append(cpdUnit.getLower().getSymbol());
            return mixable;
        }
        String mapSymbol = this.symbolMap.get(unit);
        if (mapSymbol == null) {
            throw new IllegalArgumentException("Symbol mapping for unit of type " + unit.getClass().getName() + " has not been set (see UnitFormat.SymbolMap)");
        }
        String symbol = mapSymbol;
        appendable.append(symbol);
        return appendable;
    }

    public void label(Unit<?> unit, String label) {
    }

    public boolean isLocaleSensitive() {
        return false;
    }

    protected Unit<?> parse(CharSequence csq, int index) throws MeasurementParseException {
        int start = index;
        int end = csq.length();
        if (end <= start) {
            return DimensionlessUnit.ONE;
        }
        Unit<?> result = unitMap.get(csq);
        if (result != null) {
            return result;
        }
        throw new MeasurementParseException("Error", csq, index);
    }

    public final Unit<?> parse(CharSequence csq, ParsePosition pos) throws MeasurementParseException {
        return this.parse(csq, pos.getIndex());
    }
}

