/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import tech.uom.impl.enums.format.AbstractQuantityFormat;
import tech.uom.impl.enums.format.SimpleUnitFormat;
import tech.uom.impl.enums.quantity.Quantities;
import tech.uom.impl.enums.unit.DimensionlessUnit;

public class SimpleQuantityFormat
extends AbstractQuantityFormat {
    private static final long serialVersionUID = 2447723879527543130L;
    private static final SimpleQuantityFormat DEFAULT = new SimpleQuantityFormat();

    public Appendable format(Quantity quantity, Appendable dest) throws IOException {
        Unit unit = quantity.getUnit();
        dest.append(quantity.getValue().toString());
        if (quantity.getUnit().equals((Object)DimensionlessUnit.ONE)) {
            return dest;
        }
        dest.append(' ');
        return SimpleUnitFormat.getInstance().format(unit, dest);
    }

    @Override
    public Quantity<?> parse(CharSequence csq, ParsePosition cursor) throws MeasurementParseException {
        int endDecimal;
        int startDecimal;
        for (startDecimal = cursor.getIndex(); startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
        }
        for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
        }
        BigDecimal decimal = new BigDecimal(csq.subSequence(startDecimal, endDecimal).toString());
        cursor.setIndex(endDecimal + 1);
        Unit unit = SimpleUnitFormat.getInstance().parse(csq);
        return Quantities.getQuantity(decimal, unit);
    }

    @Override
    Quantity<?> parse(CharSequence csq, int index) throws MeasurementParseException {
        int endDecimal;
        int startDecimal;
        for (startDecimal = index; startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
        }
        for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
        }
        Double decimal = new Double(csq.subSequence(startDecimal, endDecimal).toString());
        Unit unit = SimpleUnitFormat.getInstance().parse(csq);
        return Quantities.getQuantity(decimal, unit);
    }

    @Override
    public Quantity<?> parse(CharSequence csq) throws MeasurementParseException {
        return this.parse(csq, new ParsePosition(0));
    }

    public static SimpleQuantityFormat getInstance() {
        return DEFAULT;
    }
}

