/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.impl.enums;

import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.uom.impl.enums.format.UnitStyle;
import tech.uom.lib.common.function.DoubleFactorSupplier;
import tech.uom.lib.common.function.QuantityConverter;

public abstract class AbstractQuantity<Q extends Quantity<Q>>
implements Quantity<Q>,
QuantityConverter<Q>,
Comparable<Quantity<Q>> {
    private final Quantity.Scale scale;

    protected abstract Number getScalar();

    protected abstract boolean eq(AbstractQuantity<Q> var1);

    protected abstract boolean isZero();

    protected AbstractQuantity(Quantity.Scale scale) {
        this.scale = scale;
    }

    protected AbstractQuantity() {
        this(Quantity.Scale.ABSOLUTE);
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractQuantity) {
            return this.eq((AbstractQuantity)o);
        }
        return false;
    }

    public boolean isEquivalentTo(Quantity<Q> that) {
        return this.compareTo(that) == 0;
    }

    public Quantity.Scale getScale() {
        return this.scale;
    }

    public int hashCode() {
        return Objects.hash(this.getValue(), this.getUnit(), this.getScale());
    }

    public abstract String toString(boolean var1, boolean var2, int var3);

    public String toString(boolean withUnit, boolean withSpace) {
        return this.toString(withUnit, withSpace, 0);
    }

    public final <T extends Quantity<T>> AbstractQuantity<T> asType(Class<T> type) throws ClassCastException {
        this.getUnit().asType(type);
        return this;
    }

    protected String toString(boolean withSpace) {
        return this.toString(true, withSpace);
    }

    protected String toString(int precision) {
        return this.toString(true, false, precision);
    }

    public String toString() {
        return this.toString(true);
    }

    protected abstract String showInUnit(Unit<?> var1, int var2, UnitStyle var3);

    protected String showInUnit(Unit<?> u, Number s, int precision, UnitStyle style, boolean withSpace) {
        if (u == null) {
            throw new IllegalArgumentException("Null unit not allowed!");
        }
        double result = u instanceof DoubleFactorSupplier ? s.doubleValue() / ((DoubleFactorSupplier)u).getFactor() : s.doubleValue();
        String str = this.getStr(result, precision);
        switch (style) {
            case NAME: {
                StringBuilder sb = new StringBuilder(str);
                if (withSpace) {
                    sb.append(' ');
                }
                return sb.append(u.getName()).toString();
            }
        }
        StringBuilder sb = new StringBuilder(str);
        if (withSpace) {
            sb.append(' ');
        }
        return sb.append(u.getSymbol()).toString();
    }

    protected String showInUnit(Unit<?> u, Double s, int precision, UnitStyle style) {
        return this.showInUnit(u, s, precision, style, true);
    }

    protected String showInUnit(Unit<?> u, int precision) {
        return this.showInUnit(u, precision, UnitStyle.SYMBOL);
    }

    protected String getStr(Number val, int precision) {
        return String.valueOf(val);
    }
}

