/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.util;

import jakarta.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.spi.QuantityFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.mutabilitydetector.unittesting.AllowedReason;
import org.mutabilitydetector.unittesting.MutabilityAssert;
import org.mutabilitydetector.unittesting.MutabilityMatchers;
import org.reflections.ReflectionUtils;
import org.testng.Assert;
import tech.units.tck.TCKValidationException;

@Singleton
public class TestUtils {
    public static final String SYS_PROPERTY_PROFILE = "tech.units.tck.profile";
    public static final String SYS_PROPERTY_OUTPUT_DIR = "tech.units.tck.outputDir";
    public static final String SYS_PROPERTY_REPORT_FILE = "tech.units.tck.reportFile";
    public static final String SYS_PROPERTY_VERBOSE = "tech.units.tck.verbose";
    private static final StringBuilder warnings = new StringBuilder();
    private static final List<Class> PRIMITIVE_CLASSES = Collections.unmodifiableList(Arrays.asList(Object.class, Number.class, Enum.class));

    private TestUtils() {
    }

    static Number createNumberWithPrecision(QuantityFactory<?> f, int precision) {
        if (precision == 0) {
            precision = new Random().nextInt(100);
        }
        StringBuilder b = new StringBuilder(precision + 1);
        for (int i = 0; i < precision; ++i) {
            b.append(String.valueOf(i % 10));
        }
        return new Double(b.toString());
    }

    static Number createNumberWithScale(QuantityFactory<?> f, int scale) {
        StringBuilder b = new StringBuilder(scale + 2);
        b.append("9.");
        for (int i = 0; i < scale; ++i) {
            b.append(String.valueOf(i % 10));
        }
        return new Double(b.toString());
    }

    public static void testSerializable(String section, Class<?> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new TCKValidationException(section + ": Class must be serializable: " + type.getName());
        }
    }

    public static void testImmutable(String section, Class<?> type) {
        try {
            MutabilityAssert.assertInstancesOf(type, (Matcher)MutabilityMatchers.areImmutable(), (Matcher)AllowedReason.provided((Class[])new Class[]{Dimension.class, Quantity.class, Unit.class, UnitConverter.class}).areAlsoImmutable(), (Matcher)AllowedReason.allowingForSubclassing(), (Matcher)AllowedReason.allowingNonFinalFields());
        }
        catch (Exception e) {
            throw new TCKValidationException(section + ": Class is not immutable: " + type.getName(), e);
        }
    }

    public static void testSerializable(String section, Object o) {
        if (!(o instanceof Serializable)) {
            throw new TCKValidationException(section + ": Class must be serializable: " + o.getClass().getName());
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream());){
            oos.writeObject(o);
        }
        catch (Exception e) {
            throw new TCKValidationException("Class must be serializable, but serialization failed: " + o.getClass().getName(), e);
        }
    }

    public static void testImplementsInterface(String section, Class<?> type, Class<?> iface) {
        for (Class<?> ifa : type.getInterfaces()) {
            if (!ifa.equals(iface)) continue;
            return;
        }
        Assert.fail((String)(section + ": Class must implement " + iface.getName() + ", but does not: " + type.getName()));
    }

    public static void testComparable(String section, Class<?> type) {
        TestUtils.testImplementsInterface(section, type, Comparable.class);
    }

    public static void testHasPublicMethod(String section, Class<?> type, Class<?> returnType, String name, Class<?> ... paramTypes) {
        for (Class<?> current = type; current != null; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (!returnType.equals(returnType) || !m.getName().equals(name) || (m.getModifiers() & 1) == 0 || !Arrays.equals(m.getParameterTypes(), paramTypes)) continue;
                return;
            }
        }
        throw new TCKValidationException(section + ": Class must implement method " + name + '(' + Arrays.toString(paramTypes) + "): " + returnType.getName() + ", but does not: " + type.getName());
    }

    public static void testHasPublicMethod(String section, Class<?> type, boolean trySuperclassFirst, Class<?> returnType, String name, Class<?> ... paramTypes) {
        if (trySuperclassFirst && type.getSuperclass() != null) {
            if (PRIMITIVE_CLASSES.contains(type.getSuperclass())) {
                TestUtils.testHasPublicMethod(section, type, returnType, name, paramTypes);
            } else {
                TestUtils.testHasPublicMethod(section, type.getSuperclass(), returnType, name, paramTypes);
            }
        } else {
            TestUtils.testHasPublicMethod(section, type, returnType, name, paramTypes);
        }
    }

    public static void testHasPublicMethod(String section, Class<?> type, String name, boolean hasParameters) {
        Set getters = hasParameters ? ReflectionUtils.getAllMethods(type, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withName((String)name)}) : ReflectionUtils.getAllMethods(type, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withName((String)name), ReflectionUtils.withParametersCount((int)0)});
        MatcherAssert.assertThat((Object)getters.size(), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    public static void testHasPublicMethod(String section, Class<?> type, String name) {
        TestUtils.testHasPublicMethod(section, type, name, false);
    }

    static void testHasPublicStaticMethod(String section, Class type, Class returnType, String name, Class ... paramTypes) {
        for (Class current = type; current != null; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (!returnType.equals(returnType) || !m.getName().equals(name) || (m.getModifiers() & 1) == 0 || (m.getModifiers() & 8) == 0 || !Arrays.equals(m.getParameterTypes(), paramTypes)) continue;
                return;
            }
        }
        throw new TCKValidationException(section + ": Class must implement method " + name + '(' + Arrays.toString(paramTypes) + "): " + returnType.getName() + ", but does not: " + type.getName());
    }

    public static void testHasNotPublicMethod(String section, Class<?> type, Class<?> returnType, String name, Class<?> ... paramTypes) {
        for (Class<?> current = type; current != null; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (!returnType.equals(returnType) || !m.getName().equals(name) || !Arrays.equals(m.getParameterTypes(), paramTypes)) continue;
                throw new TCKValidationException(section + ": Class must NOT implement method " + name + '(' + Arrays.toString(paramTypes) + "): " + returnType.getName() + ", but does: " + type.getName());
            }
        }
    }

    public static void assertValue(String section, Object value, String methodName, Object instance) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
        Assert.assertEquals((Object)value, (Object)m.invoke(instance, new Object[0]), (String)(section + ": " + m.getName() + '(' + instance + ") returned invalid value:"));
    }

    static boolean testHasPublicStaticMethodOpt(String section, Class type, Class returnType, String methodName, Class ... paramTypes) {
        try {
            TestUtils.testHasPublicStaticMethod(section, type, returnType, methodName, paramTypes);
            return true;
        }
        catch (Exception e) {
            warnings.append(section).append(": Recommendation failed: Missing method [public static ").append(methodName).append('(').append(Arrays.toString(paramTypes)).append("):").append(returnType.getName()).append("] on: ").append(type.getName()).append("\n");
            return false;
        }
    }

    public static boolean testImmutableOpt(String section, Class type) {
        try {
            TestUtils.testImmutable(section, type);
            return true;
        }
        catch (Exception e) {
            warnings.append(section).append(": Recommendation failed: Class should be immutable: ").append(type.getName()).append(", details: ").append(e.getMessage()).append("\n");
            return false;
        }
    }

    public static boolean testSerializableOpt(String section, Class type) {
        try {
            TestUtils.testSerializable(section, type);
            return true;
        }
        catch (Exception e) {
            warnings.append(section).append(": Recommendation failed: Class should be serializable: ").append(type.getName()).append(", details: ").append(e.getMessage()).append("\n");
            return false;
        }
    }

    public static boolean testSerializableOpt(String section, Object instance) {
        try {
            TestUtils.testSerializable(section, instance);
            return true;
        }
        catch (Exception e) {
            warnings.append(section).append(": Recommendation failed: Class is serializable, but serialization failed: ").append(instance.getClass().getName()).append("\n");
            return false;
        }
    }

    static void resetWarnings() {
        warnings.setLength(0);
    }

    static String getWarnings() {
        return warnings.toString();
    }
}

