/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.unit;

import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;
import tech.units.tck.util.TestUtils;

@SpecVersion(spec="JSR 385", version="2.1.0")
public class PrefixInterfaceTest {
    private static final String SECTION = "4.2.4";

    @Test(groups={"core"}, description="4.2.4 Ensure supported Prefix classes override equals.")
    @SpecAssertion(section="4.2.4", id="424-A1")
    public void testEquals() {
        for (Class type : TCKSetup.getConfiguration().getPrefixClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.4", type, Boolean.TYPE, "equals", Object.class);
        }
    }

    @Test(groups={"core"}, description="4.2.4 Ensure supported Prefix classes override hashCode.")
    @SpecAssertion(section="4.2.4", id="424-A2")
    public void testHashcode() {
        for (Class type : TCKSetup.getConfiguration().getPrefixClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.4", type, Integer.TYPE, "hashCode", new Class[0]);
        }
    }

    @Test(groups={"core"}, description="4.2.4 Ensure supported Prefix implementations override getName.")
    @SpecAssertion(section="4.2.4", id="424-A3")
    public void testGetName() {
        for (Class type : TCKSetup.getConfiguration().getPrefixClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.4", type, "getName", true);
        }
    }

    @Test(groups={"core"}, description="4.2.4 Ensure supported Prefix implementations override getSymbol.")
    @SpecAssertion(section="4.2.4", id="424-A4")
    public void testGetSymbol() {
        for (Class type : TCKSetup.getConfiguration().getPrefixClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.4", type, "getSymbol", true);
        }
    }

    @Test(groups={"core"}, description="4.2.4 Ensure supported Prefix implementations override getValue.")
    @SpecAssertion(section="4.2.4", id="424-A5")
    public void testGetValue() {
        for (Class type : TCKSetup.getConfiguration().getPrefixClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.4", type, Number.class, "getValue", new Class[0]);
        }
    }

    @Test(groups={"core"}, description="4.2.4 Ensure supported Prefix implementations override getExponent.")
    @SpecAssertion(section="4.2.4", id="424-A6")
    public void testGetXponent() {
        for (Class type : TCKSetup.getConfiguration().getPrefixClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.4", type, Integer.TYPE, "getExponent", new Class[0]);
        }
    }
}

