/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.spi;

import java.util.Set;
import javax.measure.BinaryPrefix;
import javax.measure.MetricPrefix;
import javax.measure.spi.FormatService;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnitsService;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 385", version="2.1.0")
public class ServicesTest {
    private static final String SECTION_NUM = "5.4";
    private static final String DESCRIPTION = "5.4 Services";

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A01")
    public void testFormatService() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            FormatService service = provider.getFormatService();
            AssertJUnit.assertNotNull((String)"Section 5.4: FormatService is null", (Object)service);
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A02")
    public void testFormatServiceQuantityFormatsAvailable() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            FormatService service = provider.getFormatService();
            AssertJUnit.assertNotNull((String)"Section 5.4: FormatService is null", (Object)service);
            AssertJUnit.assertNotNull((String)"Section 5.4: Available QuantityFormat names are null", (Object)service.getAvailableFormatNames(FormatService.FormatType.QUANTITY_FORMAT));
            AssertJUnit.assertFalse((String)"Section 5.4 No available QuantityFormat names found", (boolean)service.getAvailableFormatNames(FormatService.FormatType.QUANTITY_FORMAT).isEmpty());
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A03")
    public void testFormatServiceQuantityFormatsDefault() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            FormatService service = provider.getFormatService();
            AssertJUnit.assertNotNull((String)"Section 5.4: FormatService is null", (Object)service);
            AssertJUnit.assertNotNull((String)"Section 5.4: Default QuantityFormat is null", (Object)service.getUnitFormat());
            AssertJUnit.assertNotNull((String)"Section 5.4: Available QuantityFormat names are null", (Object)service.getAvailableFormatNames(FormatService.FormatType.QUANTITY_FORMAT));
            AssertJUnit.assertFalse((String)"Section 5.4 No available QuantityFormat names found", (boolean)service.getAvailableFormatNames(FormatService.FormatType.QUANTITY_FORMAT).isEmpty());
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A04")
    public void testFormatServiceUnitFormatsAvailable() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            FormatService service = provider.getFormatService();
            AssertJUnit.assertNotNull((String)"Section 5.4: FormatService is null", (Object)service);
            AssertJUnit.assertNotNull((String)"Section 5.4: Available UnitFormat names are null", (Object)service.getAvailableFormatNames(FormatService.FormatType.UNIT_FORMAT));
            AssertJUnit.assertFalse((String)"Section 5.4 No available UnitFormat names found", (boolean)service.getAvailableFormatNames(FormatService.FormatType.UNIT_FORMAT).isEmpty());
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A05")
    public void testFormatServiceUnitFormatsDefault() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            FormatService service = provider.getFormatService();
            AssertJUnit.assertNotNull((String)"Section 5.4: FormatService is null", (Object)service);
            AssertJUnit.assertNotNull((String)"Section 5.4: Default UnitFormat is null", (Object)service.getUnitFormat());
            AssertJUnit.assertNotNull((String)"Section 5.4: Available UnitFormat names are null", (Object)service.getAvailableFormatNames(FormatService.FormatType.UNIT_FORMAT));
            AssertJUnit.assertFalse((String)"Section 5.4 No available UnitFormat names found", (boolean)service.getAvailableFormatNames(FormatService.FormatType.UNIT_FORMAT).isEmpty());
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A06")
    public void testSystemOfUnitsService() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            AssertJUnit.assertNotNull((String)"Section 5.4: SystemOfUnitsService is null", (Object)service);
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A07")
    public void testSystemOfUnitsServiceDefaultSystem() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            AssertJUnit.assertNotNull((String)"Section 5.4: SystemOfUnitsService is null", (Object)service);
            AssertJUnit.assertNotNull((String)"Section 5.4: Default SystemOfUnits is null", (Object)service.getSystemOfUnits());
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A08")
    public void testSystemOfUnitsServiceAvailableSystems() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            AssertJUnit.assertNotNull((String)"Section 5.4: SystemOfUnitsService is null", (Object)service);
            AssertJUnit.assertNotNull((String)"Section 5.4: Available SystemOfUnits are null", (Object)service.getAvailableSystemsOfUnits());
            AssertJUnit.assertFalse((String)"Section 5.4 No available SystemOfUnits found", (boolean)service.getAvailableSystemsOfUnits().isEmpty());
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A09")
    public void testSystemOfUnitsServicePrefixBinary() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            AssertJUnit.assertNotNull((String)"Section 5.4: SystemOfUnitsService is null", (Object)service);
            Set prefixes = service.getPrefixes(BinaryPrefix.class);
            AssertJUnit.assertNotNull((String)"Section 5.4: Binary Prefixes are null", (Object)prefixes);
            AssertJUnit.assertFalse((String)"Section 5.4 No Binary Prefixes found", (boolean)prefixes.isEmpty());
            Assert.assertEquals((int)8, (int)prefixes.size(), (String)"Section 5.4 Wrong Number of Binary Prefixes");
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A10")
    public void testSystemOfUnitsServicePrefixMetric() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.4: ServiceProvider is null", (Object)provider);
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            AssertJUnit.assertNotNull((String)"Section 5.4: SystemOfUnitsService is null", (Object)service);
            Set prefixes = service.getPrefixes(MetricPrefix.class);
            AssertJUnit.assertNotNull((String)"Section 5.4: Metric Prefixes are null", (Object)prefixes);
            AssertJUnit.assertFalse((String)"Section 5.4 No Metric Prefixes found", (boolean)prefixes.isEmpty());
            Assert.assertEquals((int)20, (int)prefixes.size(), (String)"Section 5.4 Wrong Number of Metric Prefixes");
        }
    }
}

