/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.spi;

import java.util.List;
import javax.measure.spi.ServiceProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 385", version="2.1.0")
public class ServiceProviderTest {
    private static final String SECTION_NUM = "5.3";
    private static final String DESCRIPTION = "5.3 Service Provider";

    @Test(groups={"spi"}, description="5.3 Service Provider")
    @SpecAssertion(section="5.3", id="53-A1")
    public void testAvailable() {
        List spa = ServiceProvider.available();
        AssertJUnit.assertNotNull((String)"Section 5.3: available ServiceProviders is null", (Object)spa);
    }

    @Test(groups={"spi"}, description="5.3 Service Provider")
    @SpecAssertion(section="5.3", id="53-A2")
    public void testAvailableNotEmpty() {
        List spa = ServiceProvider.available();
        AssertJUnit.assertNotNull((String)"Section 5.3: available ServiceProviders is null", (Object)spa);
        AssertJUnit.assertFalse((String)"Section 5.3: No available ServiceProviders found", (boolean)spa.isEmpty());
    }

    @Test(groups={"spi"}, description="5.3 Service Provider")
    @SpecAssertion(section="5.3", id="53-A3")
    public void testCurrent() {
        ServiceProvider sp = ServiceProvider.current();
        AssertJUnit.assertNotNull((String)"Section 5.3: No current ServiceProvider found", (Object)sp);
    }

    @Test(groups={"spi"}, description="5.3 Service Provider")
    @SpecAssertion(section="5.3", id="53-A4")
    public void testPriority() {
        ServiceProvider sp = ServiceProvider.current();
        MatcherAssert.assertThat((String)"Section 5.3: Priority should be a valid int", (Object)sp.getPriority(), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(Integer.MIN_VALUE)));
        MatcherAssert.assertThat((String)"Section 5.3: Priority should be a valid int", (Object)sp.getPriority(), (Matcher)OrderingComparison.lessThanOrEqualTo((Comparable)Integer.valueOf(Integer.MAX_VALUE)));
    }
}

