/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.spi;

import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.ServiceProvider;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 385", version="2.1.0")
public class QuantityFactoryTest {
    private static final String SECTION = "5.1";

    @Test(groups={"spi"}, description="5.1 Ensure a QuantityFactory implementation exists for every ServiceProvider")
    @SpecAssertion(section="5.1", id="51-A1")
    public void testQuantityFactoryExists() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            AssertJUnit.assertNotNull((String)"Section 5.1: ServiceProvider is null", (Object)provider);
            Reflections reflections = new Reflections("javax.measure", new Scanner[0]);
            Set subTypes = reflections.getSubTypesOf(Quantity.class);
            for (Class clazz : subTypes) {
                QuantityFactory factory = provider.getQuantityFactory(clazz);
                AssertJUnit.assertNotNull((String)("Section 5.1: No QuantityFactory available for " + clazz.getSimpleName() + " in " + provider), (Object)factory);
            }
        }
    }

    @Test(groups={"spi"}, description="5.1 Ensure a QuantityFactory implementation returns the correct scale")
    @SpecAssertion(section="5.1", id="51-A2")
    public void testQuantityFactoryScale() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            QuantityFactory factory = provider.getQuantityFactory(Length.class);
            Unit systemUnit = ServiceProvider.current().getSystemOfUnitsService().getSystemOfUnits().getUnit(Length.class);
            for (Quantity.Scale scale : Quantity.Scale.values()) {
                Quantity result = factory.create((Number)10.0, systemUnit, scale);
                AssertJUnit.assertEquals((Object)scale, (Object)result.getScale());
            }
        }
    }
}

