/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.quantity;

import java.util.Collection;
import java.util.HashMap;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;

@SpecVersion(spec="JSR 385", version="2.1.0")
public class QuantityTypesTest {
    private static final Logger logger = LoggerFactory.getLogger(QuantityTypesTest.class);

    @Test(groups={"base_quantity"}, description="4.4 Ensure all SI Base Quantities are used by an implementation")
    @SpecAssertion(section="4.4", id="44-A1")
    public void testContainsBaseDimensions() {
        Collection<Dimension> baseDimensions = TCKSetup.getConfiguration().getBaseDimensions();
        HashMap foundUnits = new HashMap();
        AssertJUnit.assertEquals((String)"Section 4.4: Number of SI Base Dimensions does not match", (int)7, (int)baseDimensions.size());
        Collection<Unit<?>> units = TCKSetup.getConfiguration().getUnits4Test();
        for (Unit<?> unit : units) {
            Dimension dim = unit.getDimension();
            logger.debug(unit + "D: " + dim + " (" + unit.getClass() + ")");
            if (!baseDimensions.contains(dim)) continue;
            foundUnits.put(dim, unit);
        }
        for (Dimension dimension : baseDimensions) {
            Unit unit = (Unit)foundUnits.get(dimension);
            AssertJUnit.assertNotNull((String)("Section 4.4: SI Base Dimension " + dimension + " not found"), (Object)unit);
        }
    }

    @Test(groups={"derived_quantity"}, description="4.4 Ensure all Supported Quantities are used by an implementation")
    @SpecAssertion(section="4.4", id="44-A2")
    public void testContainsQuantities() {
        Collection<Class<? extends Quantity>> quantityTypes = TCKSetup.getConfiguration().getSupportedQuantityTypes();
        for (Class<? extends Quantity> c : quantityTypes) {
            Unit<? extends Quantity> unit = TCKSetup.getConfiguration().getUnit4Type(c);
            AssertJUnit.assertNotNull((String)("Section 4.4: Quantity type " + c + " not found"), unit);
        }
    }
}

