/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.quantity;

import javax.measure.Quantity;
import javax.measure.Unit;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;
import tech.units.tck.util.TestUtils;

@SpecVersion(spec="JSR 385", version="2.1.0")
public class QuantityInterfaceTest {
    private static final String SECTION_NUM = "4.3.1";

    @Test(groups={"core"}, description="4.3.1 Ensure registered Quantity classes implement asType method.")
    @SpecAssertion(section="4.3.1", id="431-A1")
    public void testQuantityCastAsType() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1", type, false, Quantity.class, "asType", Class.class);
        }
    }

    @Test(groups={"core"}, description="4.3.1 Ensure registered Quantity classes override equals.")
    @SpecAssertion(section="4.3.1", id="431-A2")
    public void testQuantityEquals() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1", type, "equals", true);
        }
    }

    @Test(groups={"core"}, description="4.3.1 Ensure registered Quantity classes implement getScale method.")
    @SpecAssertion(section="4.3.1", id="431-A3")
    public void testQuantityGetScale() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1", type, "getScale");
        }
    }

    @Test(groups={"core"}, description="4.3.1 Ensure registered Quantity classes implement getUnit.")
    @SpecAssertion(section="4.3.1", id="431-A4")
    public void testQuantityGetUnit() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1", type, "getUnit");
        }
    }

    @Test(groups={"core"}, description="4.3.1 Ensure registered Quantity classes implement getValue.")
    @SpecAssertion(section="4.3.1", id="431-A5")
    public void testQuantityGetValue() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1", type, "getValue");
        }
    }

    @Test(groups={"core"}, description="4.3.1 Ensure registered Quantity classes override hashCode.")
    @SpecAssertion(section="4.3.1", id="431-A6")
    public void testQuantityHashCode() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1", type, "hashCode");
        }
    }

    @Test(groups={"core"}, description="4.3.1 Ensure registered Quantity classes implement isEquivalentTo method.")
    @SpecAssertion(section="4.3.1", id="431-A7")
    public void testQuantityIsEquivalentTo() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1", type, "isEquivalentTo", true);
        }
    }

    @Test(groups={"core"}, description="4.3.1 Ensure registered Quantity classes implement inverse method.")
    @SpecAssertion(section="4.3.1", id="431-A8")
    public void testQuantityOp0Inverse() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1", type, "inverse");
        }
    }

    @Test(groups={"core"}, description="4.3.1.1 Ensure registered Quantity classes implement add.")
    @SpecAssertion(section="4.3.1.1", id="4311-A1")
    public void testQuantityOp1Add() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1.1", type, Quantity.class, "add", Quantity.class);
        }
    }

    @Test(groups={"core"}, description="4.3.1.1 Ensure registered Quantity classes implement multiply by number.")
    @SpecAssertion(section="4.3.1.1", id="4311-A4")
    public void testQuantityOp1MultiplyByNumber() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1.1", type, Quantity.class, "multiply", Number.class);
        }
    }

    @Test(groups={"core"}, description="4.3.1.1 Ensure registered Quantity classes implement divide by number.")
    @SpecAssertion(section="4.3.1.1", id="4311-A5")
    public void testQuantityOp1DivideByNumber() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1.1", type, Quantity.class, "divide", Number.class);
        }
    }

    @Test(groups={"core"}, description="4.3.1.1 Ensure registered Quantity classes implement subtract.")
    @SpecAssertion(section="4.3.1.1", id="4311-A6")
    public void testQuantityOp1Subtract() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1.1", type, Quantity.class, "subtract", Quantity.class);
        }
    }

    @Test(groups={"core"}, description="4.3.1.2 Ensure registered Quantity classes implement divide.")
    @SpecAssertion(section="4.3.1.2", id="4312-A1")
    public void testQuantityOp2Divide() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1.2", type, Quantity.class, "divide", Quantity.class);
        }
    }

    @Test(groups={"core"}, description="4.3.1.2 Ensure registered Quantity classes implement multiply.")
    @SpecAssertion(section="4.3.1.2", id="4312-A2")
    public void testQuantityOp2Multiply() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1.2", type, Quantity.class, "multiply", Quantity.class);
        }
    }

    @Test(groups={"core"}, description="4.3.1 Ensure registered Quantity classes implement to method.")
    @SpecAssertion(section="4.3.1", id="431-A9")
    public void testQuantityOp0To() {
        for (Class type : TCKSetup.getConfiguration().getQuantityClasses()) {
            TestUtils.testHasPublicMethod("Section 4.3.1", type, Quantity.class, "to", Unit.class);
        }
    }
}

