/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests;

import java.util.Collection;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;

@SpecVersion(spec="JSR 385", version="2.1.0")
public class TCKSetupTest {
    private static final String SECTION_NUM = "0";

    @Test(groups={"core"}, description="TCK Setup: ensure TCK Configuration is registered and available.")
    @SpecAssertion(section="0", id="Setup", note="Tests that a TestConfiguration is registered with the JDK ServiceLoader.")
    public void testTestSetup() {
        AssertJUnit.assertTrue((String)"TCK Configuration not available.", (TCKSetup.getConfiguration() != null ? 1 : 0) != 0);
        AssertJUnit.assertNotNull((Object)TCKSetup.getConfiguration());
    }

    @Test(groups={"core"}, description="Checks that Quantity classes are registered for testing.")
    @SpecAssertion(section="0", id="Setup", note="Checks that TestConfiguration.getQuantityClasses() returns a non empty collection of quantity implementations")
    public void testQuantityConfiguration() {
        Collection<Class> quantityClasses = TCKSetup.getConfiguration().getQuantityClasses();
        AssertJUnit.assertNotNull((String)"TCK Test Configuration quantity classes are null.", quantityClasses);
        AssertJUnit.assertFalse((String)"TCK Test Configuration quantity classes is empty.", (boolean)quantityClasses.isEmpty());
    }
}

