/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.measure.BinaryPrefix;
import javax.measure.Dimension;
import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.QuantityFormat;
import javax.measure.format.UnitFormat;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.NumberDelimiterQuantityFormat;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.ExpConverter;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.quantity.NumberQuantity;
import tech.units.indriya.unit.UnitDimension;
import tech.units.indriya.unit.Units;
import tech.units.tck.util.ServiceConfiguration;

public final class TCKTestConfiguration
implements ServiceConfiguration {
    public Collection<Class> getQuantityClasses() {
        return Arrays.asList(NumberQuantity.class);
    }

    public Collection<Class> getUnitClasses() {
        try {
            return Arrays.asList(Class.forName("tech.units.indriya.unit.BaseUnit"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Unit class not loadable");
        }
    }

    public Collection<? extends Unit<?>> getUnits4Test() {
        SystemOfUnitsService service = ServiceProvider.current().getSystemOfUnitsService();
        SystemOfUnits sou = service.getSystemOfUnits();
        return sou.getUnits();
    }

    public Collection<UnitConverter> getUnitConverters4Test() {
        return Arrays.asList(new AddConverter((Number)1), new ExpConverter(1.0), new LogConverter(1.0), MultiplyConverter.of((double)0.0), MultiplyConverter.ofRational((long)2L, (long)1L), MultiplyConverter.ofPiExponent((int)10), MultiplyConverter.ofTenExponent((int)2));
    }

    public Collection<UnitFormat> getUnitFormats4Test() {
        return Arrays.asList(SimpleUnitFormat.getInstance(), EBNFUnitFormat.getInstance());
    }

    public Collection<Class> getDimensionClasses() {
        return Arrays.asList(UnitDimension.class);
    }

    public Collection<Class> getPrefixClasses() {
        return Arrays.asList(MetricPrefix.class, BinaryPrefix.class);
    }

    public Collection<Dimension> getBaseDimensions() {
        return Arrays.asList(UnitDimension.AMOUNT_OF_SUBSTANCE, UnitDimension.ELECTRIC_CURRENT, UnitDimension.LENGTH, UnitDimension.LUMINOUS_INTENSITY, UnitDimension.MASS, UnitDimension.TEMPERATURE, UnitDimension.TIME);
    }

    public Collection<Class<? extends Quantity>> getSupportedQuantityTypes() {
        Reflections reflections = new Reflections("javax.measure", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(Quantity.class);
        return subTypes;
    }

    public Unit getUnit4Type(Class quantityType) {
        return Units.getInstance().getUnit(quantityType);
    }

    public Collection<QuantityFormat> getQuantityFormats4Test() {
        return Arrays.asList(SimpleQuantityFormat.getInstance(), NumberDelimiterQuantityFormat.getInstance());
    }
}

