/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.measure.BinaryPrefix;
import javax.measure.Dimension;
import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.UnitFormat;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.ExpConverter;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.RationalConverter;
import tech.units.indriya.quantity.NumberQuantity;
import tech.units.indriya.quantity.QuantityDimension;
import tech.units.indriya.unit.Units;
import tech.units.tck.util.ServiceConfiguration;

public final class TCKTestConfiguration
implements ServiceConfiguration {
    public Collection<Class> getQuantityClasses() {
        return Arrays.asList(NumberQuantity.class);
    }

    public Collection<Class> getUnitClasses() {
        try {
            return Arrays.asList(Class.forName("tech.units.indriya.unit.BaseUnit"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Unit class not loadable");
        }
    }

    public Collection<? extends Unit<?>> getUnits4Test() {
        SystemOfUnitsService service = ServiceProvider.current().getSystemOfUnitsService();
        SystemOfUnits sou = service.getSystemOfUnits();
        return sou.getUnits();
    }

    public Collection<UnitConverter> getUnitConverters4Test() {
        return Arrays.asList(new AddConverter(1.0), new ExpConverter(1.0), new LogConverter(1.0), new MultiplyConverter(0.0), RationalConverter.of((long)2L, (long)1L));
    }

    public Collection<UnitFormat> getUnitFormats4Test() {
        return Arrays.asList(SimpleUnitFormat.getInstance());
    }

    public Collection<Class> getDimensionClasses() {
        return Arrays.asList(QuantityDimension.class);
    }

    public Collection<Class> getPrefixClasses() {
        return Arrays.asList(MetricPrefix.class, BinaryPrefix.class);
    }

    public Collection<Dimension> getBaseDimensions() {
        return Arrays.asList(QuantityDimension.AMOUNT_OF_SUBSTANCE, QuantityDimension.ELECTRIC_CURRENT, QuantityDimension.LENGTH, QuantityDimension.LUMINOUS_INTENSITY, QuantityDimension.MASS, QuantityDimension.TEMPERATURE, QuantityDimension.TIME);
    }

    public Collection<Class<? extends Quantity>> getSupportedQuantityTypes() {
        Reflections reflections = new Reflections("javax.measure", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(Quantity.class);
        return subTypes;
    }

    public Unit getUnit4Type(Class quantityType) {
        return Units.getInstance().getUnit(quantityType);
    }
}

