package com.prime.common.service.system.impl;

import com.prime.common.database.domain.system.DictCodeDO;
import com.prime.common.database.mapper.system.DictCodeMapper;
import com.prime.common.service.system.DictCodeService;
import com.touchbiz.db.starter.service.TkBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wenliluo
 */
@Slf4j
@Service
public class DictCodeServiceImpl extends TkBaseServiceImpl<DictCodeDO, DictCodeMapper> implements DictCodeService {

    @Override
    public List<DictCodeDO> getAll() {
        var example = createQueryWrapper();
        example.eq(DictCodeDO::getDeleted, false);
        example.orderByDesc(DictCodeDO::getId);
        return getMapper().selectList(example);
    }
}
