package com.prime.common.service.rpt.impl;

import com.prime.common.database.domain.rpt.AlarmAnalyzeDO;
import com.prime.common.database.mapper.rpt.AlarmAnalyzeMapper;
import com.prime.common.service.rpt.AlarmAnalyzeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import com.touchbiz.db.starter.service.TkBaseServiceImpl;
/**
 * @author wenliluo
 */
@Slf4j
@Service
public class AlarmAnalyzeServiceImpl extends TkBaseServiceImpl<AlarmAnalyzeDO, AlarmAnalyzeMapper> implements AlarmAnalyzeService {

    @Override
    public AlarmAnalyzeDO getByUniQue(AlarmAnalyzeDO alarmAnalyzeDO) {
        var example = createQueryWrapper()
                .eq(AlarmAnalyzeDO::getCategory, alarmAnalyzeDO.getCategory())
                .eq(AlarmAnalyzeDO::getCategoryId, alarmAnalyzeDO.getCategoryId())
                .eq(AlarmAnalyzeDO::getSceneType, alarmAnalyzeDO.getSceneType())
                .eq(AlarmAnalyzeDO::getAnalyzeDate, alarmAnalyzeDO.getAnalyzeDate());
        return getMapper().selectOne(example);
    }

}
