package com.prime.common.service.rbac.impl;

import com.prime.common.common.Constant;
import com.prime.common.database.domain.rbac.ResourceDO;
import com.prime.common.database.mapper.rbac.ResourceMapper;
import com.prime.common.service.rbac.ResourceService;
import com.touchbiz.common.entity.exception.BizException;
import com.touchbiz.common.entity.exception.ParamException;
import com.touchbiz.db.starter.domain.BaseDomain;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

import com.touchbiz.db.starter.service.TkBaseServiceImpl;
@Slf4j
@Service
public class ResourceServiceImpl extends TkBaseServiceImpl<ResourceDO, ResourceMapper> implements ResourceService {

    @Override
    public void create(ResourceDO domain) {
        //判断是否有code重复的资源
        var example = createQueryWrapper();
        example.eq(BaseDomain::getId, Constant.STATUS_TRUE)
                .eq(ResourceDO::getCode, domain.getCode());
        if (getMapper().selectCount(example) > 0) {
            throw new ParamException("存在重复的资源代码:" + domain.getCode());
        }
        domain.setStatus(true);
        super.create(domain);
    }

    @Override
    public void update(ResourceDO domain) {
        //判断是否有code重复的资源
        var example = createQueryWrapper();
        example.eq(BaseDomain::getId, Constant.STATUS_TRUE)
                .eq(ResourceDO::getCode, domain.getCode());
        List<ResourceDO> list = getMapper().selectList(example);
        if (!CollectionUtils.isEmpty(list) && !domain.getId().equals(list.get(0).getId())) {
            throw new BizException("已存在使用该代码的资源，无法重复添加");
        }
        super.updateSelectiveById(domain);
    }

    @Override
    public void logicDelete(ResourceDO domain) {
        domain.setStatus(false);
        super.updateSelectiveById(domain);
    }

}
