package com.prime.common.enumration.rbac;

import com.prime.common.enumration.EnumUtils;
import com.prime.common.enumration.IEnum;

import java.util.Optional;


public enum ResourceTypeEnum implements IEnum {

    MAIN_MENU(1, "主菜单"),
    SUB_MENU(-1, "子菜单"),
    BUTTON(2, "按钮"),
    URL(3, "链接"),
    ACTIVE_MENU(4, "动态菜单"),
    ;

    ResourceTypeEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<ResourceTypeEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(ResourceTypeEnum.class, code);
    }


}
