package com.prime.common.enumration;


import java.util.Optional;

public enum WorkDayTypeEnum implements IEnum {

    WORK_DAY_TYPE(124, "工作日类型"),

    NONE(124000, "未设置"),

    EVERY_DAY(124001, "每天"),

    SOMEDAY_WITH_WEEK(124002, "每周某几天"),

    SOMEDAY_WITH_MONTH(124003, "每月某几天"),

    INHERITANCE_PARENT(124004, "继承上一级，跟随上一级的时间走");

    WorkDayTypeEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<WorkDayTypeEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(WorkDayTypeEnum.class, code);
    }


}
