package com.prime.common.enumration;


import java.util.Optional;

public enum TimePlanTypeEnum implements IEnum {

    TIME_PLAN_TYPE(125, "时间计划类型"),
    NONE(125000, "未设置"),
    SCENE(125001, "场景"),
    CAMERA(125002, "场景下相机"),
    ALGORITHM(125003, "相机下算法"),
    AREA(125004, "布控区域"),
            ;

    TimePlanTypeEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<TimePlanTypeEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(TimePlanTypeEnum.class, code);
    }


}
