package com.prime.common.enumration;

import java.util.Optional;


public enum TargetEunm implements IEnum {

    /**
     * 人
     */
    PEOPLE(119001, "人"),

    /**
     * 设备
     */
    DEVICE(119002, "设备");


    TargetEunm(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<TargetEunm> getByCode(Integer code) {
        return EnumUtils.getByCode(TargetEunm.class, code);
    }
}
