package com.prime.common.enumration;

import java.util.Optional;

public enum SceneCameraAlgorithmTypeEnum implements IEnum {

    EVENT(1, "事件"),

    ALARM(0, "告警"),

    ALARM_EVENT(2, "事件与告警");

    SceneCameraAlgorithmTypeEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<SceneCameraAlgorithmTypeEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(SceneCameraAlgorithmTypeEnum.class, code);
    }
}
