package com.prime.common.enumration;

import java.util.Optional;

public enum PlatformAccountTypeEnum implements IEnum {

    YS(133001, "萤石云", AgreementTypeEnum.YS.getName()),

    HUA_WEI_3800(133002, "华为", ""),

    HAI_KANGS(133003, "海康", AgreementTypeEnum.HAI_KANG_ISC.getName());

    private final Integer code;

    private final String name;

    private final String agreement;

    PlatformAccountTypeEnum(Integer code, String name, String agreement) {
        this.code = code;
        this.name = name;
        this.agreement = agreement;
    }

    public static Optional<PlatformAccountTypeEnum> getByName(String message) {
        for (PlatformAccountTypeEnum type : PlatformAccountTypeEnum.values()) {
            if (type.getName().equals(message)) {
                return Optional.of(type);
            }
        }
        return Optional.empty();
    }

    public static Optional<PlatformAccountTypeEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(PlatformAccountTypeEnum.class, code);
    }

    @Override
    public Integer getCode() {
        return code;
    }

    @Override
    public String getName() {
        return name;
    }

    public String getAgreement() {
        return agreement;
    }
}
