package com.prime.common.enumration;

import java.util.Optional;

/**
 * @author wenliluo
 */

public enum OperateSourceTypeEnum implements IEnum {

    CREATE(1, "创建订单"),
    REFUND(2, "退款"),
    CANCEL(3, "取消预约");

    OperateSourceTypeEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<OperateSourceTypeEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(OperateSourceTypeEnum.class, code);
    }
}
