package com.prime.common.enumration;

import java.util.Optional;

public enum FlowChartStatusEnum implements IEnum {

    OK(2, "正常结束"),

    EXCEPTION(3, "异常"),

    NOT_START(0, "未开始"),

    RUNNING(1, "进行中"),

            ;

    FlowChartStatusEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<FlowChartStatusEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(FlowChartStatusEnum.class, code);
    }
}

