package com.prime.common.enumration;

import java.util.Optional;

public final class EnumUtils {

    private EnumUtils() {

    }

    /**
     * 根据code获取相应的枚举
     *
     * @param code code
     * @return 枚举
     */
    public static <T extends IEnum> Optional<T> getByCode(Class<T> clazz, Integer code) {
        if (!clazz.isEnum()) {
            return Optional.empty();
        }
        T[] objects = clazz.getEnumConstants();
        for (T obj : objects) {
            if (obj.getCode().equals(code)) {
                return Optional.of(obj);
            }
        }
        return Optional.empty();
    }

    /**
     * 根据code获取相应的名字
     *
     * @param code code
     * @return 枚举
     */
    public static <T extends IEnum> String getNameByCode(Class<T> clazz, Integer code) {
        if (!clazz.isEnum()) {
            return null;
        }
        T[] objects = clazz.getEnumConstants();
        for (T obj : objects) {
            if (obj.getCode().equals(code)) {
                return obj.getName();
            }
        }
        return null;
    }
}
