package com.prime.common.enumration;

import java.util.Optional;

public enum CameraCheckStatusEnum implements IEnum {

    UN_CONVERTED(109004, "需转换"),

    CONVERTING(109005, "转换中"),

    NOT_DETECTED(109001, "未检测"),

    PROCESSING(109002, "处理中"),

    END_OF_PROCESSING(109003, "处理结束");

    CameraCheckStatusEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<CameraCheckStatusEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(CameraCheckStatusEnum.class, code);
    }
}
