package com.prime.common.enumration;

import lombok.Getter;

import java.util.Optional;

@Getter
public enum AlarmAnalyzeEnum implements IEnum {

    ALARM_TYPE(122001, "报警类型"),

    ALARM_PLANT(122002, "报警区域"),

    ALARM_PRIORITY(122003, "报警等级");

    AlarmAnalyzeEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<AlarmAnalyzeEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(AlarmAnalyzeEnum.class, code);
    }
}
