package com.prime.common.database.domain.rpt;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("rpt_alarm_analyze")
@ApiModel("报警统计分析")
public class AlarmAnalyzeDO extends com.touchbiz.db.starter.domain.BaseDomain {

    @NotNull
    @ApiModelProperty(value = "分析类别", required = true)
    private Integer category;

    @NotNull
    @ApiModelProperty(value = "类别id", required = true)
    private Long categoryId;

    @ApiModelProperty(value = "类别名称")
    private String categoryName;

    @NotBlank
    @ApiModelProperty(value = "场景类型", required = true)
    private String sceneType;

    @NotNull
    @ApiModelProperty(value = "报警数量", required = true)
    private Integer num;

    @NotNull
    @ApiModelProperty(value = "统计时间", required = true)
    private LocalDate analyzeDate;


}
