package com.prime.common.database.domain.rbac;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("sys_resource")
public class ResourceDO extends com.touchbiz.db.starter.domain.BaseDomain {

    @NotNull(message = "资源名称不能为空")
    @ApiModelProperty("资源名称")
    private String name;

    @Min(-1)
    @Max(10)
    @NotNull(message = "资源类型不能为空")
    @ApiModelProperty("资源类型")
    private Integer type;

    @ApiModelProperty("网址")
    private String url;

    @ApiModelProperty("父节点")
    private Long parentId;

    @NotNull(message = "资源代码不能为空")
    @ApiModelProperty("资源代码")
    private String code;

    @ApiModelProperty("资源扩展数据")
    private String data;

}
