package com.prime.common.database.domain.platform;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import com.baomidou.mybatisplus.annotation.TableName;

@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@TableName("t_work_algorithm_camera")
public class WorkAlgorithmCameraDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 作业Id
     */
    @ApiModelProperty(value = "作业Id")
    @TableField("work_id")
    private Long workId;

    /**
     * 算法id
     */
    @ApiModelProperty(value = "算法id")
    @TableField("algorithm_id")
    private Long algorithmId;


    /**
     * 相机id
     */
    @ApiModelProperty(value = "相机id")
    @TableField("camera_id")
    private Long cameraId;

    /**
     * 逻辑 1任一 2全部
     */
    @ApiModelProperty(value = "逻辑")
    @TableField("logic")
    private Integer logic = 1;

    /**
     * 完成条件
     */
    @ApiModelProperty(value = "完成条件")
    @TableField("state")
    private Integer state = 1;

    /**
     * 报警等级
     */
    @ApiModelProperty(value = "完成条件")
    @TableField("priority")
    private String priority;

    /**
     * 作业生效
     */
    @ApiModelProperty(value = "作业生效")
    @TableField("work_effective")
    private Boolean workEffective = true;

    /**
     * 停止生效
     */
    @ApiModelProperty(value = "停止生效")
    @TableField("stop_effective")
    private Boolean stopEffective = true;

    /**
     * 相机名称
     */
    @ApiModelProperty(value = "相机名称")
    @TableField("camera_name")
    private String cameraName;

    /**
     * 算法名称
     */
    @ApiModelProperty(value = "算法名称")
    @TableField("algorithm_name")
    private String algrithmName;

    /**
     * 结束生效
     */
    @ApiModelProperty(value = "结束生效")
    @TableField("end_effective")
    private Boolean endEffective = true;

}
